﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WPTXDocument
        : WDBDocument
    {
        public List<WPTXPage> Pages = new List<WPTXPage>();

        public WPTXDocument(WDBReader pReader)
            : base(pReader)
        {
        }

        public override void Read(WDBReader pReader)
        {
            if (!Supported)
            {
                throw new WDBException("Unsupported version for page text cache");
            }

            WPTXPage page = null;
            while (pReader.Length > 8)
            {
                page = new WPTXPage();
                page.Read(pReader);
                Pages.Add(page);
            }
        }
    }
}
