﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WQSTCollectTask
        : IPackable
    {    
        public Int32 CollectItem = 0;
        public Int32 CollectCount = 0;        
        public void Read(WDBReader pReader)
        {            
            CollectItem = pReader.ReadInt32();
            CollectCount = pReader.ReadInt32();                        
            
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(CollectItem) &&
                   pBuf.Write(CollectCount);                  
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref CollectItem) &&
                   pBuf.Read(ref CollectCount);
        }
    }
}
