﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WQSTFactionReward
        : IPackable
    {    
        public Int32 ReputationFactionID = 0;
        public Int32 FactionRewardID = 0;
        public Int32 RewardReputationOverride = 0;

        public void Read(WDBReader pReader)
        {
            ReputationFactionID = pReader.ReadInt32();
            FactionRewardID = pReader.ReadInt32();
            RewardReputationOverride = pReader.ReadInt32();                        
            
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(ReputationFactionID) &&
                   pBuf.Write(FactionRewardID) &&
                   pBuf.Write(RewardReputationOverride);                  
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref ReputationFactionID) &&
                   pBuf.Read(ref FactionRewardID) &&
                   pBuf.Read(ref RewardReputationOverride);
        }
    }
}
