﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WQSTItem
        : IPackable
    {
        public Int32 Id = 0;
        public Int32 Count = 0;

        public void Read(WDBReader pReader)
        {
            Id = pReader.ReadInt32();
            Count = pReader.ReadInt32();
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Id) &&
                   pBuf.Write(Count);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Id) &&
                   pBuf.Read(ref Count);
        }
    }
}
