﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WQSTKillTask
        : IPackable
    {
        public Int32 KillCreature = 0;
        public Int32 KillCount = 0;        
        public void Read(WDBReader pReader)
        {
            KillCreature = pReader.ReadInt32();
            KillCount = pReader.ReadInt32();            
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(KillCreature) &&
                   pBuf.Write(KillCount);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref KillCreature) &&
                   pBuf.Read(ref KillCount);
        }
    }
}
