﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WQSTQuest
        : IPackable
    {
        public Int32 Id = 0;
        public Int32 Type = 0;
        public Int32 Level = 0;
        public Int32 AreaOrSort = 0;
        public Int32 InfoId = 0;
        public Int32 SuggestedPlayers = 0;
        public Int32 Faction = 0;
        public Int32 FactionReward = 0;
        public Int32 NextQuest = 0;
        public Int32 CoinReward = 0;
        public Int32 MaxLevelCoinReward = 0;
        public Int32 SpellReward = 0;
        public Int32 EffectOnPlayer = 0;
        public Int32 StartingItem = 0;
        public UInt32 Flags = 0;
        public String Name = "";
        public String Description = "";
        public String Details = "";
        public String SubDescription = "";
        public PackableList<WQSTTask> Tasks = new PackableList<WQSTTask>();
        public PackableList<WQSTKillTask> KillTasks = new PackableList<WQSTKillTask>();
        public PackableList<WQSTCollectTask> CollectTasks = new PackableList<WQSTCollectTask>();
        public PackableStringList Objectives = new PackableStringList();
        public PackableList<WQSTItem> GivenItems = new PackableList<WQSTItem>();
        public PackableList<WQSTItem> ChoiceItems = new PackableList<WQSTItem>();

        // Added in 3.3
        public Int32 RequiredLevel = 0;
        public Int32 UnknownInt32 = 0;
        public Int32 HostileFaction = 0;
        public Int32 HostileFactionAmount = 0;
        public Int32 XpRewardID = 0;
        public Int32 HonorReward = 0;
        public Single HonorRewardBonus = 0.0f;
        public Int32 RewardTitleID = 0;
        public Int32 RequiredPlayersKillCount = 0;
        public Int32 RewardTalentPoints = 0;
        public Int32 RewardArenaPoints = 0;
        public Int32 PointMapID;
        public Single PointX;
        public Single PointY;
        public Int32 PointOptional;

        public List<WQSTFactionReward> FactionRewards = new List<WQSTFactionReward>();

        public string CompletionText = "";

        public void Read(WDBReader pReader)
        {
            Id = pReader.ReadInt32();
            Int32 length = pReader.ReadInt32();
            Int64 begin = pReader.Length;

            Id = pReader.ReadInt32();
            Type = pReader.ReadInt32();
            Level = pReader.ReadInt32();

            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_3_0)
            {
                RequiredLevel = pReader.ReadInt32();
            }

            AreaOrSort = pReader.ReadInt32();
            InfoId = pReader.ReadInt32();
            SuggestedPlayers = pReader.ReadInt32();
            Faction = pReader.ReadInt32();
            FactionReward = pReader.ReadInt32();

            HostileFaction = pReader.ReadInt32();
            HostileFactionAmount = pReader.ReadInt32();                        

            NextQuest = pReader.ReadInt32();

            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_3_0)
            {
                XpRewardID = pReader.ReadInt32();
            }

            CoinReward = pReader.ReadInt32();
            MaxLevelCoinReward = pReader.ReadInt32();
            SpellReward = pReader.ReadInt32();
            EffectOnPlayer = pReader.ReadInt32();

            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_3_0)
            {
                HonorReward = pReader.ReadInt32();
                HonorRewardBonus = pReader.ReadSingle();
            }
            else if (pReader.Version > (Int32)WDBVersions.WowVersion_2_2_0)
            {
                pReader.Skip(4);
            }

            StartingItem = pReader.ReadInt32();
            Flags = pReader.ReadUInt32();

            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_3_0)
            {
                RewardTitleID = pReader.ReadInt32();
                RequiredPlayersKillCount = pReader.ReadInt32();
                RewardTalentPoints = pReader.ReadInt32();
                RewardArenaPoints = pReader.ReadInt32();
                UnknownInt32 = pReader.ReadInt32();
            }
            else if (pReader.Version >= (Int32)WDBVersions.WowVersion_2_4_0)
            {
                pReader.Skip(4);
            }

            // Items
            for (Int32 index = 0; index < 4; ++index)
            {
                GivenItems.Add(new WQSTItem());
                GivenItems[index].Read(pReader);
            }

            // Choice Items
            for (Int32 index = 0; index < 6; ++index)
            {
                ChoiceItems.Add(new WQSTItem());
                ChoiceItems[index].Read(pReader);
            }

            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_3_0)
            {
                int[] rewardReputationFaction = new int[5];
                int[] factionRewardID = new int[5];
                int[] rewardReputationOverride = new int[5];
                // Faction Rewards
                for (int i = 0; i < 5; i++)
                {
                    rewardReputationFaction[i] = pReader.ReadInt32();
                }

                for (int i = 0; i < 5; i++)
                {
                    factionRewardID[i] = pReader.ReadInt32();
                }

                for (int i = 0; i < 5; i++)
                {
                    rewardReputationOverride[i] = pReader.ReadInt32();
                }

                for (int i = 0; i < 5; i++)
                {
                    FactionRewards.Add(new WQSTFactionReward()
                    {
                        ReputationFactionID = rewardReputationFaction[i],
                        FactionRewardID = factionRewardID[i],
                        RewardReputationOverride = rewardReputationOverride[i]
                    });
                }


                PointMapID = pReader.ReadInt32();
                PointX = pReader.ReadSingle();
                PointY = pReader.ReadSingle();
                PointOptional = pReader.ReadInt32();
            }
            else
            {

                pReader.Skip(16);

                if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_0_1)
                {
                    pReader.Skip(8);
                }
            }

            Name = pReader.ReadString();
            Description = pReader.ReadString();
            Details = pReader.ReadString();
            SubDescription = pReader.ReadString();
            CompletionText = pReader.ReadString();


            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_3_0)
            {
                // 4 Objective CollectId
                for (Int32 index = 0; index < 4; ++index)
                {
                    CollectTasks.Add(new WQSTCollectTask());
                    CollectTasks[index].Read(pReader);
                }

                // 4 Creature Tasks
                for (Int32 index = 0; index < 4; ++index)
                {
                    KillTasks.Add(new WQSTKillTask());
                    KillTasks[index].Read(pReader);
                }

                // 6 Item Tasks
                for (Int32 index = 0; index < 6; ++index)
                {
                    CollectTasks.Add(new WQSTCollectTask());
                    CollectTasks[index].Read(pReader);
                }
            }
            else if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_0_8)
            {
                // 4 Creature Tasks
                for (Int32 index = 0; index < 4; ++index)
                {
                    KillTasks.Add(new WQSTKillTask());
                    KillTasks[index].Read(pReader);
                }

                // 5 Item Tasks
                for (Int32 index = 0; index < 5; ++index)
                {
                    CollectTasks.Add(new WQSTCollectTask());
                    CollectTasks[index].Read(pReader);
                }
            }
            else
            {
                for (Int32 index = 0; index < 4; ++index)
                {
                    Tasks.Add(new WQSTTask());
                    Tasks[index].Read(pReader);
                }
            }

            for (Int32 index = 0; index < 4; ++index)
            {
                Objectives.Add(pReader.ReadString());
            }

            Debug.Assert(begin - pReader.Length == length);
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Id) &&
                   pBuf.Write(Type) &&
                   pBuf.Write(Level) &&
                   pBuf.Write(AreaOrSort) &&
                   pBuf.Write(InfoId) &&
                   pBuf.Write(SuggestedPlayers) &&
                   pBuf.Write(Faction) &&
                   pBuf.Write(FactionReward) &&
                   pBuf.Write(NextQuest) &&
                   pBuf.Write(CoinReward) &&
                   pBuf.Write(MaxLevelCoinReward) &&
                   pBuf.Write(SpellReward) &&
                   pBuf.Write(EffectOnPlayer) &&
                   pBuf.Write(StartingItem) &&
                   pBuf.Write(Flags) &&
                   pBuf.Write(Name) &&
                   pBuf.Write(Description) &&
                   pBuf.Write(Details) &&
                   pBuf.Write(SubDescription) &&
                   Tasks.Write(pBuf) &&
                   Objectives.Write(pBuf) &&
                   GivenItems.Write(pBuf) &&
                   ChoiceItems.Write(pBuf);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Id) &&
                   pBuf.Read(ref Type) &&
                   pBuf.Read(ref Level) &&
                   pBuf.Read(ref AreaOrSort) &&
                   pBuf.Read(ref InfoId) &&
                   pBuf.Read(ref SuggestedPlayers) &&
                   pBuf.Read(ref Faction) &&
                   pBuf.Read(ref FactionReward) &&
                   pBuf.Read(ref NextQuest) &&
                   pBuf.Read(ref CoinReward) &&
                   pBuf.Read(ref MaxLevelCoinReward) &&
                   pBuf.Read(ref SpellReward) &&
                   pBuf.Read(ref EffectOnPlayer) &&
                   pBuf.Read(ref StartingItem) &&
                   pBuf.Read(ref Flags) &&
                   pBuf.Read(ref Name) &&
                   pBuf.Read(ref Description) &&
                   pBuf.Read(ref Details) &&
                   pBuf.Read(ref SubDescription) &&
                   Tasks.Read(pBuf) &&
                   Objectives.Read(pBuf) &&
                   GivenItems.Read(pBuf) &&
                   ChoiceItems.Read(pBuf);
        }
    }
}
