﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW
{
    public sealed class NPC
        : IPackable
    {
        public Int32 Id = 0;
        public Byte Gender = 0;
        public UInt16 Faction = 0;
        public PackableList<Locations> Seen = new PackableList<Locations>();
        public PackableList<NPCReaction> Reactions = new PackableList<NPCReaction>();
        public PackableList<NPCMerchandise> Merchandise = new PackableList<NPCMerchandise>();
        public PackableList<NPCMerchandise> LimitedMerchandise = new PackableList<NPCMerchandise>();
        public PackableList<NPCMerchandiseCost> MerchandiseCosts = new PackableList<NPCMerchandiseCost>();
        public PackableList<NPCTrainSkill> Teaches = new PackableList<NPCTrainSkill>();
        public PackableArray<NPCStatistics> Statistics = new PackableArray<NPCStatistics>(3);

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Id) &&
                   pBuf.Read(ref Gender) &&
                   pBuf.Read(ref Faction) &&
                   Seen.Read(pBuf) &&
                   Reactions.Read(pBuf) &&
                   Merchandise.Read(pBuf) &&
                   LimitedMerchandise.Read(pBuf) &&
                   MerchandiseCosts.Read(pBuf) &&
                   Teaches.Read(pBuf) &&
                   Statistics.Read(pBuf);
        }
    }
}
