﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace Curse.WoW
{
    public sealed class ObjectLogFile
    {
        private static TimeSpan EXPIRY = new TimeSpan(7, 0, 0, 0);
        private class Entry
        {
            public DateTime Time = DateTime.Now;
            public long Offset = 0;
        }

        private Dictionary<int, Entry> mObjects = new Dictionary<int, Entry>();
        private readonly string mPath;

        public ObjectLogFile(string path)
        {
#if DEBUG
            File.Delete(path);
#endif
            mPath = path;

            using (FileStream fs = new FileStream(path, FileMode.OpenOrCreate, FileAccess.Read))
            {
                using (BinaryReader reader = new BinaryReader(fs))
                {
                    int id;
                    Entry entry = null;
                    while (reader.BaseStream.Length - reader.BaseStream.Position > 12)
                    {
                        entry = new Entry();
                        id = reader.ReadInt32();
                        entry.Time = DateTime.FromBinary(reader.ReadInt64());
                        entry.Offset = reader.BaseStream.Position;
                        mObjects.Add(id, entry);
                    }
                }
            }
        }

        public bool AddObject(int id)
        {
            Entry entry;
            if (mObjects.TryGetValue(id, out entry))
            {
                if (DateTime.Now.Subtract(entry.Time) > EXPIRY)
                {
                    using (FileStream fs = new FileStream(mPath, FileMode.OpenOrCreate, FileAccess.Write))
                    {
                        using (BinaryWriter writer = new BinaryWriter(fs))
                        {
                            entry.Time = DateTime.Now;
                            writer.BaseStream.Seek(entry.Offset + 4, SeekOrigin.Begin);
                            writer.Write(entry.Time.ToBinary());
                        }
                    }
                    return true;
                }

                return false;
            }

            using (FileStream fs = new FileStream(mPath, FileMode.Append, FileAccess.Write))
            {
                using (BinaryWriter writer = new BinaryWriter(fs))
                {
                    entry = new Entry();
                    entry.Offset = writer.BaseStream.Position;
                    entry.Time = DateTime.Now;
                    writer.Write(id);
                    writer.Write(entry.Time.ToBinary());
                    mObjects.Add(id, entry);
                }
            }
            return true;
        }
    }
}
