﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW
{
    public sealed class Player
        : IPackable
    {
        public const Int32 COMBAT_RATINGS = 24;
        public const Int32 STATISTICS = 5;
        public const Int32 RESISTANCES = 7;
        public const Int32 EQUIPMENT_SLOTS = 20;

        public String Name = "";
        public String Server = "";
        public Byte RaceId = 0;
        public Byte ClassId = 0;
        public Byte Level = 0;
        public Int32 MaxHealth = 0;
        public Int32 MaxPower = 0;
        public Int32 Experience = 0;
        public Int32 TotalExperienceForLevel = 0;
        public String GuildName = null;
        public String GuildRank = null;
        public Byte Gender = 0;
        public Int64 Money = 0;        
        public PackableList<PlayerTalent> Talents = new PackableList<PlayerTalent>();
        public PackableInt32List Spells = new PackableInt32List();
        public PackableList<PlayerFaction> Factions = new PackableList<PlayerFaction>();
        public PackableStringList Friends = new PackableStringList();
        public PackableList<PlayerSkill> Skills = new PackableList<PlayerSkill>();
        public PackableList<PlayerTradeSkill> TradeSkills = new PackableList<PlayerTradeSkill>();
        public PackableArray<PlayerCombatRating> CombatRatings = new PackableArray<PlayerCombatRating>(COMBAT_RATINGS);
        public PackableArray<PlayerStatistic> Statistics = new PackableArray<PlayerStatistic>(STATISTICS);
        public PackableArray<PlayerStatistic> Resistances = new PackableArray<PlayerStatistic>(RESISTANCES);
        public PlayerMeleeStatistics MeleeStats = new PlayerMeleeStatistics();
        public PlayerRangedStatistics RangedStats = new PlayerRangedStatistics();
        public PlayerSpellStatistics SpellStats = new PlayerSpellStatistics();
        public PlayerDefenseStatistics DefenseStats = new PlayerDefenseStatistics();
        public PackableArray<ItemReference> Equipment = new PackableArray<ItemReference>(EQUIPMENT_SLOTS);

        public PackableInt32List RecentItems = new PackableInt32List();
        public PackableInt32List Mounts = new PackableInt32List();
        public PackableInt32List Critters = new PackableInt32List();
        public PackableInt32List Achievements = new PackableInt32List();

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }

        public Boolean Read(IReadable pBuf)
        {            
            return pBuf.Read(ref Name) &&
                   pBuf.Read(ref Server) &&
                   pBuf.Read(ref RaceId) &&
                   pBuf.Read(ref ClassId) &&
                   pBuf.Read(ref Level) &&
                   pBuf.Read(ref MaxHealth) &&
                   pBuf.Read(ref MaxPower) &&
                   pBuf.Read(ref Experience) &&
                   pBuf.Read(ref TotalExperienceForLevel) &&
                   pBuf.Read(ref GuildName) &&
                   pBuf.Read(ref GuildRank) &&
                   pBuf.Read(ref Gender) &&
                   pBuf.Read(ref Money) &&
                   Talents.Read(pBuf) &&
                   Spells.Read(pBuf) &&
                   Factions.Read(pBuf) &&
                   Friends.Read(pBuf) &&
                   Skills.Read(pBuf) &&
                   TradeSkills.Read(pBuf) &&
                   CombatRatings.Read(pBuf) &&
                   Statistics.Read(pBuf) &&
                   Resistances.Read(pBuf) &&
                   MeleeStats.Read(pBuf) &&
                   RangedStats.Read(pBuf) &&
                   SpellStats.Read(pBuf) &&
                   DefenseStats.Read(pBuf) &&
                   Equipment.Read(pBuf) &&
                   RecentItems.Read(pBuf) &&
                   Mounts.Read(pBuf) &&
                   Critters.Read(pBuf) &&
                   Achievements.Read(pBuf);
        }
    }
}
