﻿using System;

namespace Curse.Extensions
{
    public static class DateTimeExtensions
    {
        public static DateTime NormalizeToUtc(this DateTime value)
        {
            if (value.Kind == DateTimeKind.Local)
            {
                return value.ToUniversalTime();
            }
            else
            {
                return value;
            }
        }

        private static readonly DateTime Epoch = new DateTime(1970, 1, 1);

        public static DateTime FromEpoch(long milliseconds)
        {
            return Epoch + TimeSpan.FromMilliseconds(milliseconds);
        }

        public static long ToEpoch(this DateTime value)
        {
            return (long)(value.ToUniversalTime() - Epoch).TotalMilliseconds;
        }
    }
}
