﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.ComponentModel;
using System.Xml.Serialization;

namespace Curse.Extensions
{
    public static class EnumExtensions
    {
        public static string GetEnumDescription(this Enum value)
        {
            if (value == null)
            {
                throw new ArgumentNullException("value");
            }

            FieldInfo fi = value.GetType().GetField(value.ToString());

            DescriptionAttribute[] descriptionAttributes = fi.GetCustomAttributes(typeof(DescriptionAttribute), false)
                as DescriptionAttribute[];
            if (descriptionAttributes != null && descriptionAttributes.Length > 0)
            {
                return descriptionAttributes[0].Description;
            }
            XmlEnumAttribute[] xmlAttributes = fi.GetCustomAttributes(typeof(XmlEnumAttribute), false) as XmlEnumAttribute[];
            if (xmlAttributes != null && xmlAttributes.Length > 0)
            {
                return xmlAttributes[0].Name;
            }

            return value.ToString();
        }
    }
}
