﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;

namespace Curse.Extensions
{
    public static class HttpWebRequestExtensions
    {
        public static HttpWebResponse DoFormPost(this HttpWebRequest request, string postVals, int timeoutSeconds, IWebProxy proxy)
        {
           request.Proxy = proxy;
           return request.DoFormPost(postVals, timeoutSeconds);
        } 

        public static HttpWebResponse DoFormPost(this HttpWebRequest request, string postVals, int timeoutSeconds)
        {                        
            request.Method = "POST";            
            request.Timeout = timeoutSeconds * 1000;
            request.ContentType = "application/x-www-form-urlencoded";
            request.AllowAutoRedirect = false;            
            byte[] postData = System.Text.Encoding.UTF8.GetBytes(postVals);
            request.ContentLength = postData.Length;
            using (Stream newStream = request.GetRequestStream())
            {
                newStream.Write(postData, 0, postData.Length);
            }
            return (HttpWebResponse)request.GetResponse();
        }
    }
}
