﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;

namespace Curse.Extensions
{
    public static class IPAddressExtensions
    {
        /// <summary>
        /// Returns the numeric representation of an IPAddress
        /// </summary>
        /// <param name="pIpAddress"></param>
        /// <returns></returns>
        public static Int64 ToInt64(this IPAddress value)
        {

            byte[] ipBytes = value.GetAddressBytes();
            Int64 ip = 0;
            for (int i = 0; i < ipBytes.Length; i++)
            {
                ip <<= 8;
                ip += ipBytes[i];
            }
            return ip;
        }
    }
}
