﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Security.Cryptography;

namespace Curse
{
    public class RSAEncryption
    {
         /* -1. Pre-sign data.
          * 1. Receive public key from client
          * 2. Encrypt algorithm.
          * 3. Send back algorithm           
          */

        private RSACryptoServiceProvider sRSAProvider = null;

        public RSAEncryption(string pPrivateClientSource)
        {
            sRSAProvider = new RSACryptoServiceProvider();
            String keyXML = null;
            using (StreamReader reader = new System.IO.StreamReader(pPrivateClientSource))
            {
                keyXML = reader.ReadToEnd();
            }

            sRSAProvider.FromXmlString(keyXML);
        }

        public byte[] GetShellSignature(byte[] pShellCode, Int32 pStartByte, Int32 pLength)
        {
         
            byte[] pSegment = new byte[pLength];
            Buffer.BlockCopy(pShellCode, pStartByte, pSegment, 0, pLength);
            byte[] pSignature = sRSAProvider.SignData(pShellCode, SHA1.Create());
            return pSignature;
        }

        public byte[] Decrypt(byte[] pData)
        {
            return sRSAProvider.Decrypt(pData, true);            
        }

        public byte[] Encrypt(String pPublicKey, byte[] pData)
        {
            RSACryptoServiceProvider rsaProvider = new RSACryptoServiceProvider(GetParameters());            
            rsaProvider.FromXmlString(pPublicKey);            

            byte[] encryptedData = null;
            try
            {
                encryptedData = rsaProvider.Encrypt(pData, true);
            }
            catch (CryptographicException ex)
            {
                System.Diagnostics.Debug.WriteLine(ex.Message + "\nStack:" + ex.StackTrace);
            }

            return encryptedData;
        }

        public static CspParameters GetParameters()
        {
            const int PROVIDER_RSA_FULL = 1;
            const string CONTAINER_NAME = "CurseContainer";
            CspParameters cspParams;
            cspParams = new CspParameters(PROVIDER_RSA_FULL);
            cspParams.KeyContainerName = CONTAINER_NAME;
            cspParams.Flags = CspProviderFlags.UseMachineKeyStore;
            cspParams.ProviderName = "Microsoft Strong Cryptographic Provider";
            
            return cspParams;
        }
       
      
    }
}
