﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace Curse
{
    public class SmartSemaphore
    {

        private Semaphore _semaphore;
        private TimeSpan _timeout;

        public SmartSemaphore(int maximumEntries, int timeoutMilliseconds = 1000)
        {
            _semaphore = new Semaphore(1, maximumEntries);
            _timeout = TimeSpan.FromMilliseconds(timeoutMilliseconds);
        }

        public class SemaphoreLock : IDisposable
        {
            private SmartSemaphore _parent;

            public SemaphoreLock(SmartSemaphore parent)
            {
                _parent = parent;
            }

            public void Dispose()
            {
                _parent.Release();;
            }

        }

        public SemaphoreLock Begin()
        {
            try
            {
                _semaphore.WaitOne(_timeout);
            }
            catch (Exception)
            {
                return null;
            }
            
            return new SemaphoreLock(this);
        }

        protected void Release()
        {
            _semaphore.Release();
        }
        
    }
}
