﻿using System;

namespace Curse
{
    /**
     * Single-byte Enum supporting response status codes used by various services
     *
     * @author Michael Comperda
     */
    public enum StatusCode
        : byte
    {
        Ok = 0,
        InvalidStream,
        InvalidGameClientVersion,
        InvalidProfilerVersion,
        
        AuthenticationUnavailable = 10,
        AuthenticationFailed,
        AuthenticationInvalidSession,
        AuthenticationNotPremium,
        AuthenticationInvalidUser,
        AuthenticationError,

        ProfileInvalidGame = 20,
        ProfileNoData,

        AddOnNotFound = 30,
        AddOnNoHints=31,

        WebConnectionFailure = 254,
        Unknown = 255
    }
}
