﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Extensions;
using System.Configuration;
using System.Data.SqlClient;
using Curse.GameServers.Extensions;
using System.Web.Caching;
using Curse.GameServers.Configuration;

namespace Curse.GameServers.Caching
{
    public class GameCache
    {
        private string _cacheKey = "GameByID = {0}";

        static GameCache _instance = new GameCache();
        public static GameCache Instance { get { return _instance; } }

        public GameCache() { }
        public void Initialize() { }

        #region Caching
        public CGameForServer GetGameByID(int gameId)
        {
            return HttpRuntime.Cache.Get(_cacheKey.FormatWith(gameId), () =>
            {
                return GetFromDatabaseByID(gameId);
            });
        }
        private CGameForServer GetFromDatabaseByID(int gameId)
        {
            try
            {
                using (var conn = DatabaseConfiguration.GetGameServerConnection())
                {
                    var cmd = new SqlCommand("SELECT ID, Title, Description, Status, Slug FROM Game WHERE ID = @ID", conn);
                    cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = gameId;

                    using (var reader = cmd.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            var game = new CGameForServer();
                            game.SetFromDataReader(reader);

                            HttpRuntime.Cache.Insert(_cacheKey.FormatWith(gameId), game, null, DateTime.Now.AddHours(1), Cache.NoSlidingExpiration);
                            return game;
                        }
                        else
                        {
                            return null;
                        }
                    }
                }
            }
            catch (Exception exc)
            {
                Logger.Log("Failed to get Game with Id {0} from the database. Details: {1}", ELogLevel.Error, gameId, exc.GetExceptionDetails());
                return null;
            }
        }
        #endregion
    }
}