﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using Curse.Extensions;
using System.Data.SqlClient;
using Curse.GameServers.Extensions;
using System.Web.Caching;
using Curse.GameServers.Configuration;

namespace Curse.GameServers.Caching
{
    public class GameServerTypeCache
    {
        private string _cacheKey = "GameServerTypeByDataSourceID = {0}";

        static GameServerTypeCache _instance = new GameServerTypeCache();
        public static GameServerTypeCache Instance { get { return _instance; } }

        public GameServerTypeCache() { }
        public void Initialize() { }

        #region Caching
        public List<CGameServerType> GetAllGameServerTypesByDataSouce(int dataSourceId)
        {
            return HttpRuntime.Cache.Get(_cacheKey.FormatWith(dataSourceId), () =>
            {
                return GetFromDatabaseByID(dataSourceId);
            });
        }
        private List<CGameServerType> GetFromDatabaseByID(int dataSourceId)
        {
            var gameServerTypes = new List<CGameServerType>();
            try
            {
                using (var conn = DatabaseConfiguration.GetGameServerConnection())
                {
                    var cmd = new SqlCommand("SELECT * FROM GameServerType WHERE GameServerDataSourceID = @ID", conn);
                    cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = dataSourceId;

                    using (var reader = cmd.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            var gameServerType = new CGameServerType();
                            gameServerType.SetFromDataReader(reader);

                            gameServerTypes.Add(gameServerType);
                        }
                    }
                }

                HttpRuntime.Cache.Insert(_cacheKey.FormatWith(dataSourceId), gameServerTypes, null, DateTime.Now.AddHours(1), Cache.NoSlidingExpiration);
                return gameServerTypes;
            }
            catch (Exception exc)
            {
                Logger.Log("Failed to get GameServerPlugins for data source Id {0} from the database. Details: {1}", ELogLevel.Error, dataSourceId, exc.GetExceptionDetails());
                return null;
            }
        }
        #endregion
    }
}