﻿using System;
using System.Data.SqlClient;
using Curse.Extensions;

namespace Curse.GameServers.Extensions
{
    public static class CGameReleaseExtensions
    {
        public static void SetFromDataReader(this CGameRelease release, SqlDataReader reader)
        {
            release.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            release.SiteID = reader.GetInt32(reader.GetOrdinal("SiteID"));
            release.GameID = reader.GetInt32(reader.GetOrdinal("GameID"));
            release.ClientGameID = reader.GetInt32(reader.GetOrdinal("ClientGameID"));
            release.GameSlug = reader.GetString(reader.GetOrdinal("GameSlug"));
            release.Slug = reader.GetString(reader.GetOrdinal("Slug"));
            release.Title = reader.GetString(reader.GetOrdinal("Title"));
            release.ReleaseDate = reader.GetDateTime(reader.GetOrdinal("ReleaseDate"));
            release.FileSize = reader.GetInt32(reader.GetOrdinal("FileSize"));
            release.ReleaseType = (EGameReleaseType)reader.GetInt32(reader.GetOrdinal("ReleaseType"));
            release.ReleaseNotesLink = reader.GetNullableValue<string>("ReleaseNotesLink");
            release.ReleaseNotes = reader.GetNullableValue<string>("ReleaseNotes");
            release.DownloadURL = string.Format("http://assets.minecraft.net/{0}/minecraft.jar", release.Title);
        }
    }
}