﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using Curse.GameServers.Caching;
using Curse.Extensions;

namespace Curse.GameServers.Extensions
{
    public static class CGameServerDataSourceExtensions
    {
        public static void SetFromDataReader(this CGameServerDataSource dataSource, SqlDataReader reader)
        {
            dataSource.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            
            dataSource.GameID = reader.GetInt32(reader.GetOrdinal("GameID"));
            dataSource.Game = GameCache.Instance.GetGameByID(dataSource.GameID);

            dataSource.GameServerProcessorID = reader.GetInt32(reader.GetOrdinal("GameServerProcessorID"));
            dataSource.GameServerProcessor = GameServerProcessorCache.Instance.GetGameProcessorByID(dataSource.GameServerProcessorID);
            
            dataSource.Name = reader.GetString(reader.GetOrdinal("Name"));
            dataSource.Configuration = reader.GetString(reader.GetOrdinal("Configuration"));
            dataSource.ListDiscoveryType = (ListDiscoveryType)reader.GetByte(reader.GetOrdinal("ListDiscoveryType"));
            dataSource.DefaultPort = reader.GetNullableValue<int>("DefaultPort");

            dataSource.GameServerPlugins = GameServerPluginCache.Instance.GetAllDataSourcePlugins(dataSource.ID);
            dataSource.GameServerPluginsByID = dataSource.GameServerPlugins.ToDictionary(p => p.ID);
            dataSource.GameServerTypes = GameServerTypeCache.Instance.GetAllGameServerTypesByDataSouce(dataSource.ID);
        }
    }
}