﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;

namespace Curse.GameServers.Extensions
{
    public static class CGameServerPropertyExtensions
    {
        public static void SetFromDataReader(this CGameServerProperty property, SqlDataReader reader)
        {
            property.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            property.GameServerID = reader.GetInt32(reader.GetOrdinal("GameServerDataSourceID"));
            property.GameServerPropertyTypeID = reader.GetInt32(reader.GetOrdinal("GameServerPropertyTypeID"));
            property.Value = reader.GetString(reader.GetOrdinal("Value"));
        }

        public static void SetFromDataReader(this CGameServerPropertyType propertyType, SqlDataReader reader)
        {
            propertyType.ID = reader.GetInt32(reader.GetOrdinal("GameServerPropertyTypeID"));
            propertyType.GameServerDataSourceID = reader.GetInt32(reader.GetOrdinal("GameServerDataSourceID"));
            propertyType.Name = reader.GetString(reader.GetOrdinal("Name"));
            propertyType.TypeName = reader.GetString(reader.GetOrdinal("TypeName"));
            propertyType.DefaultValue = reader.GetString(reader.GetOrdinal("DefaultValue"));
        }        
    }
}