﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;

namespace Curse.GameServers
{
    [ServiceContract]
    public interface IGameServerService
    {
        #region GameServers
        [OperationContract]
        [WebGet]
        CGameServerDataSource[] GetAllDataSources();

        [OperationContract]
        [WebGet]
        CGameServerDataSource[] GetDataSourcesByGameID(int gameId);

        [OperationContract]
        [WebGet]
        CGameServer[] GetAllGameServers();

        [OperationContract]
        [WebGet]
        CGameServer[] GetGameServersByDataSourceID(string dataSourceName);

        [OperationContract]
        [WebGet]
        CGameServer[] GetAllGameServerActivitySince(long since);

        [OperationContract]
        [WebGet]
        CGameServer[] GetAllGameServerActivityByDataSourceSince(string dataSourceName, long since);

        [OperationContract]
        //CServiceResponse CreateGameServer(string dataSourceName, byte[] ipAddress, int port, string slug);
        CServiceResponse CreateGameServer(string dataSourceName, byte[] ipAddress, int port, string slug, int? queryPort, int? gameServerRatingId);

        [OperationContract]
        CServiceResponse ClaimGameServer(int gameServerId, int userId);

        [OperationContract]
        CServiceResponse UploadTagIcon(int tagId, byte[] iconBytes);

        [OperationContract]
        CServiceResponse SetServerVerification(string dataSourceName, byte[] ipAddress, int port, Guid verificationToken, EVerificationStatus verificationStatus);

        [OperationContract]
        CServiceResponse UpdateGameServerStatus(string dataSourceName, byte[] ipAddress, int port, GameServerStatus newStatus);

        [OperationContract]
        CGameServer[] GetFilteredGameServers(int takeLimit);
        
        [OperationContract]
        CGameServer[] GetFilteredGameServersByDataSourceSince(string dataSourceName, long since, int takeLimit);

        [OperationContract]
        CServiceResponse UpdateGameServerCountry(string dataSourceName, byte[] ipAddress, int port, string countryCode);

        [OperationContract]
        void QueueServerImmediately(string dataSourceName, byte[] ipAddress, int port);

        [OperationContract]
        CServiceResponse UpdateGameServerQueryPort(string dataSourceName, byte[] ipAddress, int port, int queryPort);

        [OperationContract]
        CServiceResponse UpdateGameServerRatingID(string dataSourceName, byte[] ipAddress, int port, int? ratingId);

        [OperationContract]
        CServiceResponse CreateGameServerRating(string title, string description, EGameServerRatingStatus status);

        [OperationContract]
        CServiceResponse UpdateGameServerRating(int gameServerRatingId, string title, string description, EGameServerRatingStatus status);

        [OperationContract]
        CServiceResponse DeleteGameServerRating(int gameServerRatingId);
        #endregion

        #region Game Releases
        [OperationContract]
        CGameRelease[] GetAllGameReleases();

        [OperationContract]
        CGameRelease[] GetAllGameReleasesByGameID(int gameID);

        [OperationContract]
        CServiceResponse UpdateGameReleaseNotes(int releaseId, string releaseNotes, string releaseNoteLink);
        #endregion
    }    
}
