﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace HardwareCenter
{
    /**
     * Handles CPU details for transmission
     *
     * @author Shane Bryldt
     */
    public sealed class CPU
        : IPackable
    {
        public UInt32 Vendor0Id = 0;
        public UInt32 Vendor1Id = 0;
        public UInt32 Vendor2Id = 0;
        public UInt32 ExtendedFamily = 0;
        public UInt32 Type = 0;
        public UInt32 Family = 0;
        public UInt32 Model = 0;
        public UInt32 ExtendedModel = 0;
        public UInt32 Stepping = 0;
        public UInt32 Brand = 0;
        public UInt32 Count = 0;
        public UInt32 Feature0Flags = 0;
        public UInt32 Feature1Flags = 0;
        public UInt32 ExtendedBrand = 0;
        public UInt32 ExtendedFeature0Flags = 0;
        public UInt32 ExtendedFeature1Flags = 0;
        public Byte Cache0 = 0;
        public Byte Cache1 = 0;
        public Byte Cache2 = 0;
        public Byte Cache3 = 0;
        public Byte Cache4 = 0;
        public Byte Cache5 = 0;
        public Byte Cache6 = 0;
        public Byte Cache7 = 0;
        public Byte Cache8 = 0;
        public Byte Cache9 = 0;
        public Byte Cache10 = 0;
        public Byte Cache11 = 0;
        public Byte Cache12 = 0;
        public Byte Cache13 = 0;
        public Byte Cache14 = 0;
        public Byte Cache15 = 0;
        public UInt32 L1DataCache = 0;
        public UInt32 L1CodeCache = 0;
        public UInt32 L2Cache = 0;
        public UInt32 L3Cache = 0;
        public UInt32 Frequency = 0;
        public String Description = null;

        /**
         * Implements IPackable Write
         * 
         * @param  pBuf  the buffer accessed using IWritable
         * @return       true if all the data was written, false otherwise
         */
        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Vendor0Id) &&
                   pBuf.Write(Vendor1Id) &&
                   pBuf.Write(Vendor2Id) &&
                   pBuf.Write(ExtendedFamily) &&
                   pBuf.Write(Type) &&
                   pBuf.Write(Family) &&
                   pBuf.Write(Model) &&
                   pBuf.Write(ExtendedModel) &&
                   pBuf.Write(Stepping) &&
                   pBuf.Write(Brand) &&
                   pBuf.Write(Count) &&
                   pBuf.Write(Feature0Flags) &&
                   pBuf.Write(Feature1Flags) &&
                   pBuf.Write(ExtendedBrand) &&
                   pBuf.Write(ExtendedFeature0Flags) &&
                   pBuf.Write(ExtendedFeature1Flags) &&
                   pBuf.Write(Cache0) &&
                   pBuf.Write(Cache1) &&
                   pBuf.Write(Cache2) &&
                   pBuf.Write(Cache3) &&
                   pBuf.Write(Cache4) &&
                   pBuf.Write(Cache5) &&
                   pBuf.Write(Cache6) &&
                   pBuf.Write(Cache7) &&
                   pBuf.Write(Cache8) &&
                   pBuf.Write(Cache9) &&
                   pBuf.Write(Cache10) &&
                   pBuf.Write(Cache11) &&
                   pBuf.Write(Cache12) &&
                   pBuf.Write(Cache13) &&
                   pBuf.Write(Cache14) &&
                   pBuf.Write(Cache15) &&
                   pBuf.Write(L1DataCache) &&
                   pBuf.Write(L1CodeCache) &&
                   pBuf.Write(L2Cache) &&
                   pBuf.Write(L3Cache) &&
                   pBuf.Write(Frequency) &&
                   pBuf.Write(Description);
        }

        /**
         * Implements IPackable Read
         * 
         * @param  pBuf  the buffer accessed using IReadable
         * @return       true if all the data was read, false otherwise
         */
        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Vendor0Id) &&
                   pBuf.Read(ref Vendor1Id) &&
                   pBuf.Read(ref Vendor2Id) &&
                   pBuf.Read(ref ExtendedFamily) &&
                   pBuf.Read(ref Type) &&
                   pBuf.Read(ref Family) &&
                   pBuf.Read(ref Model) &&
                   pBuf.Read(ref ExtendedModel) &&
                   pBuf.Read(ref Stepping) &&
                   pBuf.Read(ref Brand) &&
                   pBuf.Read(ref Count) &&
                   pBuf.Read(ref Feature0Flags) &&
                   pBuf.Read(ref Feature1Flags) &&
                   pBuf.Read(ref ExtendedBrand) &&
                   pBuf.Read(ref ExtendedFeature0Flags) &&
                   pBuf.Read(ref ExtendedFeature1Flags) &&
                   pBuf.Read(ref Cache0) &&
                   pBuf.Read(ref Cache1) &&
                   pBuf.Read(ref Cache2) &&
                   pBuf.Read(ref Cache3) &&
                   pBuf.Read(ref Cache4) &&
                   pBuf.Read(ref Cache5) &&
                   pBuf.Read(ref Cache6) &&
                   pBuf.Read(ref Cache7) &&
                   pBuf.Read(ref Cache8) &&
                   pBuf.Read(ref Cache9) &&
                   pBuf.Read(ref Cache10) &&
                   pBuf.Read(ref Cache11) &&
                   pBuf.Read(ref Cache12) &&
                   pBuf.Read(ref Cache13) &&
                   pBuf.Read(ref Cache14) &&
                   pBuf.Read(ref Cache15) &&
                   pBuf.Read(ref L1DataCache) &&
                   pBuf.Read(ref L1CodeCache) &&
                   pBuf.Read(ref L2Cache) &&
                   pBuf.Read(ref L3Cache) &&
                   pBuf.Read(ref Frequency) &&
                   pBuf.Read(ref Description);
        }
    }
}
