﻿using System;

namespace HardwareCenter
{
    /**
     * Partial class DB containing pre-baked SQL statements
     *
     * @author Shane Bryldt
     */
    public static partial class DB
    {
        private static String sCPUQueryFormat =
            "UPDATE cpu SET " +            
            "vendorid0={0}," +
            "vendorid1={1}," +
            "vendorid2={2}," +
            "extendedfamily={3}," +
            "type={4}," +
            "family={5}," +
            "model={6}," +
            "extendedmodel={7}," +
            "stepping={8}," +
            "brand={9}," +
            "count={10}," +
            "featureflags0={11}," +
            "featureflags1={12}," +
            "extendedbrand={13}," +
            "extendedfeatures0={14}," +
            "extendedfeatures1={15}," +
            "cache0={16}," +
            "cache1={17}," +
            "cache2={18}," +
            "cache3={19}," +
            "cache4={20}," +
            "cache5={21}," +
            "cache6={22}," +
            "cache7={23}," +
            "cache8={24}," +
            "cache9={25}," +
            "cache10={26}," +
            "cache11={27}," +
            "cache12={28}," +
            "cache13={29}," +
            "cache14={30}," +
            "cache15={31}," +
            "l1datacache={32}," +
            "l1codecache={33}," +
            "l2cache={34}," +
            "l3cache={35}," +
            "frequency={36}," +
            "description={37}," +
            "updated=GETUTCDATE()," +
            "laptop={39}" +
            " WHERE owner_id={38}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO cpu(" +
            "owner_id,vendorid0,vendorid1,vendorid2," +
            "extendedfamily,type,family,model,extendedmodel,stepping," +
            "brand,count,featureflags0,featureflags1,extendedbrand,extendedfeatures0,extendedfeatures1," +
            "cache0,cache1,cache2,cache3,cache4,cache5,cache6," +
            "cache7,cache8,cache9,cache10,cache11,cache12,cache13,cache14,cache15," +
            "l1datacache,l1codecache,l2cache,l3cache,frequency,description,laptop) VALUES(" +
            "{38},{0},{1},{2}," +
            "{3},{4},{5},{6},{7},{8}," +
            "{9},{10},{11},{12},{13},{14},{15}," +
            "{16},{17},{18},{19},{20},{21},{22}," +
            "{23},{24},{25},{26},{27},{28},{29},{30},{31}," +
            "{32},{33},{34},{35},{36},{37},{39});";

        private static String sGPUInsertQueryFormat =
            "INSERT INTO gpu(" +
            "owner_id,caps0,caps1,caps2,presentationintervals,cursorcaps," +
            "devcaps0,devcaps1,primitivemisccaps,rastercaps,zcmpcaps," +
            "srcblendcaps,destblendcaps,alphacmpcaps,shadecaps," +
            "texturecaps,texturefiltercaps,cubetexturefiltercaps,volumetexturefiltercaps," +
            "textureaddresscaps,volumetextureaddresscaps,linecaps," +
            "maxtexturewidth,maxtextureheight,maxvolumeextent,maxtexturerepeat,maxtextureaspectratio," +
            "maxanisotropy,maxvertexw," +
            "guardbandleft,guardbandtop,guardbandright,guardbandbottom,extentsadjust," +
            "stencilcaps,fvfcaps,textureopcaps,maxtextureblendstages,maxsimultaneoustextures," +
            "vertexprocessingcaps,maxactivelights,maxuserclipplanes," +
            "maxvertexblendmatrices,maxvertexblendmatrixindex,maxpointsize," +
            "maxprimitivecount,maxvertexindex,maxstreams,maxstreamstride," +
            "vertexshaderversion,maxvertexshaderconst,pixelshaderversion,pixelshader1xmaxvalue," +
            "maxnpatchtessellationlevel,masteradapterordinal,adapterordinalingroup,numberofadaptersingroup," +
            "decltypes,numsimultaneousrts,stretchrectfiltercaps," +
            "vs20caps,vs20dynamicflowcontroldepth,vs20numtemps,vs20staticflowcontroldepth," +
            "ps20caps,ps20dynamicflowcontroldepth,ps20numtemps,ps20staticflowcontroldepth,ps20numinstructionslots," +
            "vertextexturefiltercaps,maxvshaderinstructionsexecuted," +
            "maxvertexshader30instructionslots,maxpixelshader30instructionslots,description," +
            "mvendorid,mdeviceid,subsysid,revision," +
            "driverproduct,driverversion,driversubversion,driverbuild,memorysize) VALUES(" +
            "{0},{1},{2},{3},{4},{5}," +
            "{6},{7},{8},{9},{10}," +
            "{11},{12},{13},{14}," +
            "{15},{16},{17},{18}," +
            "{19},{20},{21}," +
            "{22},{23},{24},{25},{26}," +
            "{27},{28}," +
            "{29},{30},{31},{32},{33}," +
            "{34},{35},{36},{37},{38}," +
            "{39},{40},{41}," +
            "{42},{43},{44}," +
            "{45},{46},{47},{48}," +
            "{49},{50},{51},{52}," +
            "{53},{54},{55},{56}," +
            "{57},{58},{59}," +
            "{60},{61},{62},{63}," +
            "{64},{65},{66},{67},{68}," +
            "{69},{70}," +
            "{71},{72},{73}," +
            "{74},{75},{76},{77}," +
            "{78},{79},{80},{81},{82});";

        private static String sHDInsertQueryFormat =
            "INSERT INTO hd(" +
            "owner_id,spacefree,spacetotal) VALUES(" +
            "{0},{1},{2});";

        private static String sRAMQueryFormat =
            "UPDATE ram SET " +
            "sizefree={0}," +
            "sizetotal={1}," +
            "updated=GETUTCDATE()" +
            " WHERE owner_id={2}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO ram(" +
            "owner_id,sizefree,sizetotal) VALUES(" +
            "{2},{0},{1});";

        private static String sOSQueryFormat =
            "UPDATE os SET " +
            "majorversion={0}," +
            "minorversion={1}," +
            "buildversion={2}," +
            "platformid={3}," +
            "updated=GETUTCDATE()" +
            " WHERE owner_id={4}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO os(" +
            "owner_id,majorversion,minorversion,buildversion,platformid) VALUES(" +
            "{4},{0},{1},{2},{3});";

        private static String sSoundQueryFormat =
            "UPDATE sound SET " +
            "flags={0}," +
            "minsecondarysamplerate={1}," +
            "maxsecondarysamplerate={2}," +
            "primarybuffers={3}," +
            "maxhwmixingallbuffers={4}," +
            "maxhwmixingstaticbuffers={5}," +
            "maxhwmixingstreamingbuffers={6}," +
            "freehwmixingallbuffers={7}," +
            "freehwmixingstaticbuffers={8}," +
            "freehwmixingstreamingbuffers={9}," +
            "maxhw3dallbuffers={10}," +
            "maxhw3dstaticbuffers={11}," +
            "maxhw3dstreamingbuffers={12}," +
            "freehw3dallbuffers={13}," +
            "freehw3dstaticbuffers={14}," +
            "freehw3dstreamingbuffers={15}," +
            "totalhwmembytes={16}," +
            "freehwmembytes={17}," +
            "maxcontigfreehwmembytes={18}," +
            "unlocktransferratehwbuffers={19}," +
            "playcpuoverheadswbuffers={20}," +
            "description={21}," +
            "updated=GETUTCDATE()" +
            " WHERE owner_id={22}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO sound(" +
            "owner_id,flags,minsecondarysamplerate,maxsecondarysamplerate,primarybuffers," +
            "maxhwmixingallbuffers,maxhwmixingstaticbuffers,maxhwmixingstreamingbuffers," +
            "freehwmixingallbuffers,freehwmixingstaticbuffers,freehwmixingstreamingbuffers," +
            "maxhw3dallbuffers,maxhw3dstaticbuffers,maxhw3dstreamingbuffers," +
            "freehw3dallbuffers,freehw3dstaticbuffers,freehw3dstreamingbuffers," +
            "totalhwmembytes,freehwmembytes,maxcontigfreehwmembytes,unlocktransferratehwbuffers," +
            "playcpuoverheadswbuffers,description) VALUES(" +
            "{22},{0},{1},{2},{3}," +
            "{4},{5},{6}," +
            "{7},{8},{9}," +
            "{10},{11},{12}," +
            "{13},{14},{15}," +
            "{16},{17},{18},{19}," +
            "{20},{21});";

        private static String sDisplayQueryFormat =
            "UPDATE display SET " +
            "desktopwidth={0}," +
            "desktopheight={1}," +
            "updated=GETUTCDATE()" +
            " WHERE owner_id={2}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO display(" +
            "owner_id,desktopwidth,desktopheight) VALUES(" +
            "{2},{0},{1});";
    }
}
