﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace HardwareCenter
{
    /**
     * Handles Display details for transmission
     *
     * @author Shane Bryldt
     */
    public sealed class Display
        : IPackable
    {
        public UInt32 DesktopWidth = 0;
        public UInt32 DesktopHeight = 0;

        /**
         * Implements IPackable Write
         * 
         * @param  pBuf  the buffer accessed using IWritable
         * @return       true if all the data was written, false otherwise
         */
        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(DesktopWidth) &&
                   pBuf.Write(DesktopHeight);
        }

        /**
         * Implements IPackable Read
         * 
         * @param  pBuf  the buffer accessed using IReadable
         * @return       true if all the data was read, false otherwise
         */
        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref DesktopWidth) &&
                   pBuf.Read(ref DesktopHeight);

        }
    }
}
