﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace HardwareCenter
{
    /**
     * Handles GPU details for transmission
     *
     * @author Shane Bryldt
     */
    public sealed class GPU
        : IPackable
    {
        public UInt32 Caps0 = 0;
        public UInt32 Caps1 = 0;
        public UInt32 Caps2 = 0;
        public UInt32 PresentationIntervals = 0;
        public UInt32 CursorCaps = 0;
        public UInt32 DevCaps0 = 0;
        public UInt32 DevCaps1 = 0;
        public UInt32 PrimitiveMiscCaps = 0;
        public UInt32 RasterCaps = 0;
        public UInt32 ZCmpCaps = 0;
        public UInt32 SrcBlendCaps = 0;
        public UInt32 DestBlendCaps = 0;
        public UInt32 AlphaCmpCaps = 0;
        public UInt32 ShadeCaps = 0;
        public UInt32 TextureCaps = 0;
        public UInt32 TextureFilterCaps = 0;
        public UInt32 CubeTextureFilterCaps = 0;
        public UInt32 VolumeTextureFilterCaps = 0;
        public UInt32 TextureAddressCaps = 0;
        public UInt32 VolumeTextureAddressCaps = 0;
        public UInt32 LineCaps = 0;
        public UInt32 MaxTextureWidth = 0;
        public UInt32 MaxTextureHeight = 0;
        public UInt32 MaxVolumeExtent = 0;
        public UInt32 MaxTextureRepeat = 0;
        public UInt32 MaxTextureAspectRatio = 0;
        public UInt32 MaxAnisotropy = 0;
        public Single MaxVertexW = 0;
        public Single GuardBandLeft = 0;
        public Single GuardBandTop = 0;
        public Single GuardBandRight = 0;
        public Single GuardBandBottom = 0;
        public Single ExtentsAdjust = 0;
        public UInt32 StencilCaps = 0;
        public UInt32 FVFCaps = 0;
        public UInt32 TextureOpCaps = 0;
        public UInt32 MaxTextureBlendStages = 0;
        public UInt32 MaxSimultaneousTextures = 0;
        public UInt32 VertexProcessingCaps = 0;
        public UInt32 MaxActiveLights = 0;
        public UInt32 MaxUserClipPlanes = 0;
        public UInt32 MaxVertexBlendMatrices = 0;
        public UInt32 MaxVertexBlendMatrixIndex = 0;
        public Single MaxPointSize = 0;
        public UInt32 MaxPrimitiveCount = 0;
        public UInt32 MaxVertexIndex = 0;
        public UInt32 MaxStreams = 0;
        public UInt32 MaxStreamStride = 0;
        public UInt32 VertexShaderVersion = 0;
        public UInt32 MaxVertexShaderConst = 0;
        public UInt32 PixelShaderVersion = 0;
        public Single PixelShader1xMaxValue = 0;
        public Single MaxNpatchTessellationLevel = 0;
        public UInt32 MasterAdapterOrdinal = 0;
        public UInt32 AdapterOrdinalInGroup = 0;
        public UInt32 NumberOfAdaptersInGroup = 0;
        public UInt32 DeclTypes = 0;
        public UInt32 NumSimultaneousRTs = 0;
        public UInt32 StretchRectFilterCaps = 0;
        public UInt32 VS20Caps = 0;
        public UInt32 VS20DynamicFlowControlDepth = 0;
        public UInt32 VS20NumTemps = 0;
        public UInt32 VS20StaticFlowControlDepth = 0;
        public UInt32 PS20Caps = 0;
        public UInt32 PS20DynamicFlowControlDepth = 0;
        public UInt32 PS20NumTemps = 0;
        public UInt32 PS20StaticFlowControlDepth = 0;
        public UInt32 PS20NumInstructionSlots = 0;
        public UInt32 VertexTextureFilterCaps = 0;
        public UInt32 MaxVShaderInstructionsExecuted = 0;
        public UInt32 MaxPShaderInstructionsExecuted = 0;
        public UInt32 MaxVertexShader30InstructionSlots = 0;
        public UInt32 MaxPixelShader30InstructionSlots = 0;
        public String Description = null;
        public UInt32 VendorId = 0;
        public UInt32 DeviceId = 0;
        public UInt32 SubSysId = 0;
        public UInt32 Revision = 0;
        public UInt32 DriverProduct = 0;
        public UInt32 DriverVersion = 0;
        public UInt32 DriverSubVersion = 0;
        public UInt32 DriverBuild = 0;
        public UInt32 MemorySize = 0;

        /**
         * Implements IPackable Write
         * 
         * @param  pBuf  the buffer accessed using IWritable
         * @return       true if all the data was written, false otherwise
         */
        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Caps0) &&
                   pBuf.Write(Caps1) &&
                   pBuf.Write(Caps2) &&
                   pBuf.Write(PresentationIntervals) &&
                   pBuf.Write(CursorCaps) &&
                   pBuf.Write(DevCaps0) &&
                   pBuf.Write(DevCaps1) &&
                   pBuf.Write(PrimitiveMiscCaps) &&
                   pBuf.Write(RasterCaps) &&
                   pBuf.Write(ZCmpCaps) &&
                   pBuf.Write(SrcBlendCaps) &&
                   pBuf.Write(DestBlendCaps) &&
                   pBuf.Write(AlphaCmpCaps) &&
                   pBuf.Write(ShadeCaps) &&
                   pBuf.Write(TextureCaps) &&
                   pBuf.Write(TextureFilterCaps) &&
                   pBuf.Write(CubeTextureFilterCaps) &&
                   pBuf.Write(VolumeTextureFilterCaps) &&
                   pBuf.Write(TextureAddressCaps) &&
                   pBuf.Write(VolumeTextureAddressCaps) &&
                   pBuf.Write(LineCaps) &&
                   pBuf.Write(MaxTextureWidth) &&
                   pBuf.Write(MaxTextureHeight) &&
                   pBuf.Write(MaxVolumeExtent) &&
                   pBuf.Write(MaxTextureRepeat) &&
                   pBuf.Write(MaxTextureAspectRatio) &&
                   pBuf.Write(MaxAnisotropy) &&
                   pBuf.Write(MaxVertexW) &&
                   pBuf.Write(GuardBandLeft) &&
                   pBuf.Write(GuardBandTop) &&
                   pBuf.Write(GuardBandRight) &&
                   pBuf.Write(GuardBandBottom) &&
                   pBuf.Write(ExtentsAdjust) &&
                   pBuf.Write(StencilCaps) &&
                   pBuf.Write(FVFCaps) &&
                   pBuf.Write(TextureOpCaps) &&
                   pBuf.Write(MaxTextureBlendStages) &&
                   pBuf.Write(MaxSimultaneousTextures) &&
                   pBuf.Write(VertexProcessingCaps) &&
                   pBuf.Write(MaxActiveLights) &&
                   pBuf.Write(MaxUserClipPlanes) &&
                   pBuf.Write(MaxVertexBlendMatrices) &&
                   pBuf.Write(MaxVertexBlendMatrixIndex) &&
                   pBuf.Write(MaxPointSize) &&
                   pBuf.Write(MaxPrimitiveCount) &&
                   pBuf.Write(MaxVertexIndex) &&
                   pBuf.Write(MaxStreams) &&
                   pBuf.Write(MaxStreamStride) &&
                   pBuf.Write(VertexShaderVersion) &&
                   pBuf.Write(MaxVertexShaderConst) &&
                   pBuf.Write(PixelShaderVersion) &&
                   pBuf.Write(PixelShader1xMaxValue) &&
                   pBuf.Write(MaxNpatchTessellationLevel) &&
                   pBuf.Write(MasterAdapterOrdinal) &&
                   pBuf.Write(AdapterOrdinalInGroup) &&
                   pBuf.Write(NumberOfAdaptersInGroup) &&
                   pBuf.Write(DeclTypes) &&
                   pBuf.Write(NumSimultaneousRTs) &&
                   pBuf.Write(StretchRectFilterCaps) &&
                   pBuf.Write(VS20Caps) &&
                   pBuf.Write(VS20DynamicFlowControlDepth) &&
                   pBuf.Write(VS20NumTemps) &&
                   pBuf.Write(VS20StaticFlowControlDepth) &&
                   pBuf.Write(PS20Caps) &&
                   pBuf.Write(PS20DynamicFlowControlDepth) &&
                   pBuf.Write(PS20NumTemps) &&
                   pBuf.Write(PS20StaticFlowControlDepth) &&
                   pBuf.Write(PS20NumInstructionSlots) &&
                   pBuf.Write(VertexTextureFilterCaps) &&
                   pBuf.Write(MaxVShaderInstructionsExecuted) &&
                   pBuf.Write(MaxPShaderInstructionsExecuted) &&
                   pBuf.Write(MaxVertexShader30InstructionSlots) &&
                   pBuf.Write(MaxPixelShader30InstructionSlots) &&
                   pBuf.Write(Description) &&
                   pBuf.Write(VendorId) &&
                   pBuf.Write(DeviceId) &&
                   pBuf.Write(SubSysId) &&
                   pBuf.Write(Revision) &&
                   pBuf.Write(DriverProduct) &&
                   pBuf.Write(DriverVersion) &&
                   pBuf.Write(DriverSubVersion) &&
                   pBuf.Write(DriverBuild) &&
                   pBuf.Write(MemorySize);
        }

        /**
         * Implements IPackable Read
         * 
         * @param  pBuf  the buffer accessed using IReadable
         * @return       true if all the data was read, false otherwise
         */
        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Caps0) &&
                   pBuf.Read(ref Caps1) &&
                   pBuf.Read(ref Caps2) &&
                   pBuf.Read(ref PresentationIntervals) &&
                   pBuf.Read(ref CursorCaps) &&
                   pBuf.Read(ref DevCaps0) &&
                   pBuf.Read(ref DevCaps1) &&
                   pBuf.Read(ref PrimitiveMiscCaps) &&
                   pBuf.Read(ref RasterCaps) &&
                   pBuf.Read(ref ZCmpCaps) &&
                   pBuf.Read(ref SrcBlendCaps) &&
                   pBuf.Read(ref DestBlendCaps) &&
                   pBuf.Read(ref AlphaCmpCaps) &&
                   pBuf.Read(ref ShadeCaps) &&
                   pBuf.Read(ref TextureCaps) &&
                   pBuf.Read(ref TextureFilterCaps) &&
                   pBuf.Read(ref CubeTextureFilterCaps) &&
                   pBuf.Read(ref VolumeTextureFilterCaps) &&
                   pBuf.Read(ref TextureAddressCaps) &&
                   pBuf.Read(ref VolumeTextureAddressCaps) &&
                   pBuf.Read(ref LineCaps) &&
                   pBuf.Read(ref MaxTextureWidth) &&
                   pBuf.Read(ref MaxTextureHeight) &&
                   pBuf.Read(ref MaxVolumeExtent) &&
                   pBuf.Read(ref MaxTextureRepeat) &&
                   pBuf.Read(ref MaxTextureAspectRatio) &&
                   pBuf.Read(ref MaxAnisotropy) &&
                   pBuf.Read(ref MaxVertexW) &&
                   pBuf.Read(ref GuardBandLeft) &&
                   pBuf.Read(ref GuardBandTop) &&
                   pBuf.Read(ref GuardBandRight) &&
                   pBuf.Read(ref GuardBandBottom) &&
                   pBuf.Read(ref ExtentsAdjust) &&
                   pBuf.Read(ref StencilCaps) &&
                   pBuf.Read(ref FVFCaps) &&
                   pBuf.Read(ref TextureOpCaps) &&
                   pBuf.Read(ref MaxTextureBlendStages) &&
                   pBuf.Read(ref MaxSimultaneousTextures) &&
                   pBuf.Read(ref VertexProcessingCaps) &&
                   pBuf.Read(ref MaxActiveLights) &&
                   pBuf.Read(ref MaxUserClipPlanes) &&
                   pBuf.Read(ref MaxVertexBlendMatrices) &&
                   pBuf.Read(ref MaxVertexBlendMatrixIndex) &&
                   pBuf.Read(ref MaxPointSize) &&
                   pBuf.Read(ref MaxPrimitiveCount) &&
                   pBuf.Read(ref MaxVertexIndex) &&
                   pBuf.Read(ref MaxStreams) &&
                   pBuf.Read(ref MaxStreamStride) &&
                   pBuf.Read(ref VertexShaderVersion) &&
                   pBuf.Read(ref MaxVertexShaderConst) &&
                   pBuf.Read(ref PixelShaderVersion) &&
                   pBuf.Read(ref PixelShader1xMaxValue) &&
                   pBuf.Read(ref MaxNpatchTessellationLevel) &&
                   pBuf.Read(ref MasterAdapterOrdinal) &&
                   pBuf.Read(ref AdapterOrdinalInGroup) &&
                   pBuf.Read(ref NumberOfAdaptersInGroup) &&
                   pBuf.Read(ref DeclTypes) &&
                   pBuf.Read(ref NumSimultaneousRTs) &&
                   pBuf.Read(ref StretchRectFilterCaps) &&
                   pBuf.Read(ref VS20Caps) &&
                   pBuf.Read(ref VS20DynamicFlowControlDepth) &&
                   pBuf.Read(ref VS20NumTemps) &&
                   pBuf.Read(ref VS20StaticFlowControlDepth) &&
                   pBuf.Read(ref PS20Caps) &&
                   pBuf.Read(ref PS20DynamicFlowControlDepth) &&
                   pBuf.Read(ref PS20NumTemps) &&
                   pBuf.Read(ref PS20StaticFlowControlDepth) &&
                   pBuf.Read(ref PS20NumInstructionSlots) &&
                   pBuf.Read(ref VertexTextureFilterCaps) &&
                   pBuf.Read(ref MaxVShaderInstructionsExecuted) &&
                   pBuf.Read(ref MaxPShaderInstructionsExecuted) &&
                   pBuf.Read(ref MaxVertexShader30InstructionSlots) &&
                   pBuf.Read(ref MaxPixelShader30InstructionSlots) &&
                   pBuf.Read(ref Description) &&
                   pBuf.Read(ref VendorId) &&
                   pBuf.Read(ref DeviceId) &&
                   pBuf.Read(ref SubSysId) &&
                   pBuf.Read(ref Revision) &&
                   pBuf.Read(ref DriverProduct) &&
                   pBuf.Read(ref DriverVersion) &&
                   pBuf.Read(ref DriverSubVersion) &&
                   pBuf.Read(ref DriverBuild) &&
                   pBuf.Read(ref MemorySize);

        }
    }
}
