﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace HardwareCenter
{
    /**
     * Handles HD details for transmission
     *
     * @author Shane Bryldt
     */
    public sealed class HD
        : IPackable
    {
        public UInt64 SpaceFree = 0;
        public UInt64 SpaceTotal = 0;

        /**
         * Implements IPackable Write
         * 
         * @param  pBuf  the buffer accessed using IWritable
         * @return       true if all the data was written, false otherwise
         */
        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(SpaceFree) &&
                   pBuf.Write(SpaceTotal);
        }

        /**
         * Implements IPackable Read
         * 
         * @param  pBuf  the buffer accessed using IReadable
         * @return       true if all the data was read, false otherwise
         */
        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref SpaceFree) &&
                   pBuf.Read(ref SpaceTotal);

        }
    }
}
