﻿using System;
using System.IO;
using System.Xml.Serialization;
using Curse.Logging;

namespace Curse.Jobs.Runner.Configuration
{
    public enum ConfigurationMode
    {
        Debug,
        Release
    }

    [XmlType("JobRunner")]
    public class JobRunnerConfiguration
    {
        [XmlElement]
        public string LogServiceUrl { get; set; }

        [XmlElement]
        public string LogServiceApiKey { get; set; }

        [XmlElement]
        public string EleriumDatabaseConnectionString { get; set; }
        
        public static ConfigurationMode Mode { get; private set; }

        private static readonly JobRunnerConfiguration _instance = null;

        public static JobRunnerConfiguration Instance
        {
            get { return _instance; }
        }

        static JobRunnerConfiguration()
        {
            
#if CONFIG_DEBUG
            Mode = ConfigurationMode.Debug;
#elif CONFIG_RELEASE
            Mode = ConfigurationMode.Release;
#endif
            // Try to load the config, based on the compilation mode

            Logger.Info("Current configuration is: " + Mode);
            
            var configPath = FindConfigPath();

            Logger.Info("Loading JobRunner configuration from: " + configPath);

            using (var reader = new StreamReader(configPath))
            {
                var dcs = new XmlSerializer(typeof(JobRunnerConfiguration));
                _instance = (JobRunnerConfiguration)dcs.Deserialize(reader);
            }

        }

        private static string FindConfigPath()
        {
            string configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configuration", "JobRunner." + Mode.ToString() + ".config");

            if (!File.Exists(configPath))
            {
                configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "bin", "JobRunner." + Mode.ToString() + ".config");
            }

            if (!File.Exists(configPath))
            {
                throw new Exception("Configuration could not be loaded from '" + configPath + "'");
            }

            return configPath;
        }

    }
}
