﻿using System;
using System.Collections.Generic;
using System.ServiceProcess;
using System.Threading;
using Curse.Database.Helpers;
using Curse.Jobs.Runner.Configuration;
using Curse.Logging;
using Curse.Logging.Uploader;

namespace Curse.Jobs.Runner
{
    partial class CurseJobRunnerService : ServiceBase
    {
        private CancellationTokenSource _cts;

        public CurseJobRunnerService()
        {
            InitializeComponent();
        }

        internal void OnDebugStart()
        {
            OnStart(null);
        }

        protected override void OnStart(string[] args)
        {
            Logger.Init(new LoggerConfig(@"C:\Curse\Logs") { LogRetainCount = 10, MaxLogSize = Int32.MaxValue });
            Logger.Info("Starting service...");
            LogUploader.Initialize(11, JobRunnerConfiguration.Instance.LogServiceUrl, JobRunnerConfiguration.Instance.LogServiceApiKey);
            Logger.Info("Initialzing database connection...");
            DatabaseConnectionHelper.Initialize(new Dictionary<DatabaseType, string> { { DatabaseType.Elerium, JobRunnerConfiguration.Instance.EleriumDatabaseConnectionString } });
            _cts = new CancellationTokenSource();
            Logger.Info("Starting scheduler...");
            JobScheduler.Instance.Run(_cts.Token);
        }

        internal void OnDebugStop()
        {
            OnStop();
        }

        protected override void OnStop()
        {
            Logger.Info("Stopping service...");
            _cts.Cancel();
            LogUploader.Shutdown();
            _cts = null;
        }
    }
}
