﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.ServiceProcess;
using System.Text;
using System.Threading.Tasks;
using Curse.Minecraft.Jobs.Forge;
using Curse.Minecraft.Jobs.Utilities;

namespace Curse.Jobs.Runner
{
    class Program
    {
        static void Main(string[] args)
        {
            if (Debugger.IsAttached)
            {

                //var package = new MavenPackageString("com.typesafe.akka:akka-actor_2.11:2.3.3", url: new Uri("http://mavencentral.cursecdn.com/maven2/", UriKind.Absolute));
                //ModLoaderHelper.GetNewUri(package.AbsoluteUrl);

                var service = new CurseJobRunnerService();

                Console.WriteLine("Starting Curse Job Runner Service.");
                service.OnDebugStart();

                Console.WriteLine("Curse Job Runner Service is running. Press Enter to exit.");
                Console.ReadLine();
                service.OnDebugStop();
            }
            else
            {
                ServiceBase.Run(new ServiceBase[] {new CurseJobRunnerService()});
            }
        }
    }
}
