﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Curse.Jobs
{
    public class JobScheduler
    {
        private static readonly JobScheduler _instance = new JobScheduler();
        public static JobScheduler Instance { get { return _instance; } }

        [ImportMany]
        private BaseJob[] Jobs { get; set; }

        private readonly Dictionary<BaseJob, DateTime> _lastRunDates;

        public JobScheduler()
        {
            ImportJobs();
            _lastRunDates = Jobs.ToDictionary(j => j, j => DateTime.MinValue);
        }

        public void Run(CancellationToken cancelToken)
        {
            Task.Factory.StartNew(() => SchedulerThread(Jobs, cancelToken), cancelToken, TaskCreationOptions.LongRunning, TaskScheduler.Default);
        }

        private void SchedulerThread(BaseJob[] jobs, CancellationToken cancelToken)
        {
            while (!cancelToken.IsCancellationRequested)
            {
                foreach (var job in jobs)
                {
                    var localJob = job;
                    if (localJob.ShouldRun(_lastRunDates[localJob]))
                    {
                        _lastRunDates[localJob] = DateTime.UtcNow;
                        Task.Factory.StartNew(() => localJob.Run(cancelToken), cancelToken);
                    }
                }
                Thread.Sleep(30000);
            }
        }

        private void ImportJobs()
        {
            var catalog = new AggregateCatalog();
            catalog.Catalogs.Add(new ApplicationCatalog());
            var container = new CompositionContainer(catalog);

            container.ComposeParts(this);
        }
    }
}
