#include "LZO.h"

array<System::Byte> ^LZO::MiniLZO::Compress(array<System::Byte> ^dataIn, int offset, int length)
{
	lzo_uint lenIn = (lzo_uint)length;
	array<System::Byte> ^dataOut = gcnew array<System::Byte>(length + (length / 16) + 64 + 3);
    lzo_uint lenOut = (lzo_uint)dataOut->Length;
	lzo_byte workmem[LZO1X_MEM_COMPRESS];
	GCHandle ^hIn = GCHandle::Alloc(dataIn, GCHandleType::Pinned);
	GCHandle ^hOut = GCHandle::Alloc(dataOut, GCHandleType::Pinned);
	const lzo_bytep pIn = (const lzo_bytep)hIn->AddrOfPinnedObject().ToPointer();
	lzo_bytep pOut = (lzo_bytep)hOut->AddrOfPinnedObject().ToPointer();

	lzo1x_1_compress(pIn + offset, lenIn, pOut, &lenOut, workmem);

	hIn->Free();
	hOut->Free();

	Array::Resize(dataOut, (int)lenOut);
	return dataOut;
}

array<System::Byte> ^LZO::MiniLZO::Decompress(array<System::Byte> ^dataIn, int offset, int length, int origLength)
{
	lzo_uint lenIn = (lzo_uint)length;
	array<System::Byte> ^dataOut = gcnew array<System::Byte>(origLength);
    lzo_uint lenOut = (lzo_uint)dataOut->Length;
	lzo_byte workmem[LZO1X_MEM_COMPRESS];
	GCHandle ^hIn = GCHandle::Alloc(dataIn, GCHandleType::Pinned);
	GCHandle ^hOut = GCHandle::Alloc(dataOut, GCHandleType::Pinned);
	const lzo_bytep pIn = (const lzo_bytep)hIn->AddrOfPinnedObject().ToPointer();
	lzo_bytep pOut = (lzo_bytep)hOut->AddrOfPinnedObject().ToPointer();

	lzo1x_decompress_safe(pIn + offset, lenIn, pOut, &lenOut, workmem);

	hIn->Free();
	hOut->Free();

	Array::Resize(dataOut, (int)lenOut);
	return dataOut;
}
