﻿using System;
using System.Text;
using System.Net.Mail;
using System.Net.Mime;
using LogFileErrorMonitor.Properties;


namespace LogFileErrorMonitor
{
    class Mailer
    {
        private static readonly Mailer _instance = new Mailer();
        private Encoding _mailEncoding = Encoding.GetEncoding("utf-8");


        public static Mailer Instance
        {
            get
            {
                return _instance;
            }
        }

        public void SendMail(string templateName, string appName, string sendEmailTo)
        {

            System.Net.Mail.SmtpClient _client = new System.Net.Mail.SmtpClient(Settings.Default.SMTPServer);

            System.Net.Mail.MailMessage _message = new System.Net.Mail.MailMessage();
            _message.To.Add(sendEmailTo);
            _message.From = new System.Net.Mail.MailAddress(Settings.Default.NotificationEmailFrom);
            _message.Subject = Settings.Default.NotificationEmailSubject + " for " + appName + " -- " + System.DateTime.Now.ToShortDateString(); 

            string htmlBody = String.Empty;

            if (templateName == "LogFileReport")
            {

                #region HTML Body

                htmlBody = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'> 
                <html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>
                <head>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>
                <title>SQLServer DB Index Frag Report</title>
                </head>
                <body style='font-family: verdana,arial,helvetica,sans-serif; font-size: 12px;'>
                <p>This email is a notification that the current log file has grown beyond it's specified size limit.</p>";
                
                htmlBody = htmlBody + "</body></html>";

                #endregion

                if (!htmlBody.ToLower().StartsWith("<doctype>") && !htmlBody.ToLower().StartsWith("<html>"))
                {
                    htmlBody = String.Format("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HTML><HEAD><META http-equiv=Content-Type content=\"text/html; charset=iso-8859-1\"></HEAD><BODY>{0}</BODY></HTML>", htmlBody);
                }
            }

            _message.BodyEncoding = _mailEncoding;

            AlternateView htmlView = AlternateView.CreateAlternateViewFromString(htmlBody, _mailEncoding, "text/html");
            _message.AlternateViews.Add(htmlView);

            _client.Send(_message);
        }
    }
}
