﻿using System;
using System.Linq;
using System.IO;


namespace LogFileErrorMonitor
{
    class Program
    {
        static void Main(string[] args)
        {

            ConsoleAppsConfigCollection caCollection = ReporterConfiguration.Instance._ConsoleAppsConfig;

            for (int i = 0; i < caCollection.Count; i++)
            {
                DirectoryInfo dir = new DirectoryInfo(caCollection[i].Path);
                var directories = dir.GetFiles();

                FileInfo d = directories.OrderByDescending(f => f.LastWriteTime).First();

                TimeSpan time = d.CreationTime - d.LastWriteTime;

                int days = time.Days;

                if (days == 0)
                {
                    days = 1;
                }

                long size = d.Length / days;

                int size1 = Convert.ToInt32(size);

                int size2 = Convert.ToInt32(caCollection[i].LimitSize);


                if (size1 > size2)
                {
                    Mailer.Instance.SendMail("LogFileReport", caCollection[i].Name, caCollection[i].SendEmailTo);
                }

            }
        }
    }
}
