﻿using System;
using System.IO;
using System.Xml.Serialization;
using Curse.Logging;

namespace Curse.Jobs.Runner.Configuration
{
    public enum ConfigurationMode
    {
        Debug,
        Release
    }

    [XmlType("MinecraftJob")]
    public class MinecraftJobConfiguration
    {
        [XmlElement]
        public string ModLoaderSharePath { get; set; }

        [XmlElement]
        public string ModLoaderBaseUrl { get; set; }

        [XmlElement]
        public bool RebuildMode { get; set; }

        public static ConfigurationMode Mode { get; private set; }

        private static readonly MinecraftJobConfiguration _instance = null;

        public static MinecraftJobConfiguration Instance
        {
            get { return _instance; }
        }

        static MinecraftJobConfiguration()
        {

#if CONFIG_DEBUG
            Mode = ConfigurationMode.Debug;
#elif CONFIG_RELEASE
            Mode = ConfigurationMode.Release;
#endif
            // Try to load the config, based on the compilation mode

            Logger.Info("Current configuration is: " + Mode);

            var configPath = FindConfigPath();

            Logger.Info("Loading JobRunner configuration from: " + configPath);

            using (var reader = new StreamReader(configPath))
            {
                var dcs = new XmlSerializer(typeof(MinecraftJobConfiguration));
                _instance = (MinecraftJobConfiguration)dcs.Deserialize(reader);
            }

        }

        private static string FindConfigPath()
        {
            string configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configuration", "MinecraftJob." + Mode.ToString() + ".config");

            if (!File.Exists(configPath))
            {
                configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "bin", "MinecraftJob." + Mode.ToString() + ".config");
            }

            if (!File.Exists(configPath))
            {
                throw new Exception("Configuration could not be loaded from '" + configPath + "'");
            }

            return configPath;
        }

    }
}
