﻿using System;
using System.IO;
using Curse.Minecraft.Jobs.Utilities;

namespace Curse.Minecraft.Jobs.Forge
{
    public class ForgeDownloadInfo
    {
        public ForgeDownloadInfo(Uri downloadBaseUrl, string artifact, string fullVersion, string fileType, string extension)
        {
            FileName = string.Format("{0}-{1}-{2}.{3}", artifact, fullVersion, fileType, extension);
            DownloadUrl = new Uri(downloadBaseUrl, new Uri(fullVersion + "/" + FileName, UriKind.Relative));
        }

        public ForgeDownloadInfo(Uri downloadUrl)
        {
            DownloadUrl = downloadUrl;
            FileName = Path.GetFileName(downloadUrl.LocalPath);
        }

        public Uri DownloadUrl { get; set; }
        public string FileName { get; set; }
    }
}
