﻿
using System;

namespace Curse.Minecraft.Jobs.Forge
{
    public class ForgeInfo
    {
        public ForgeInfo(string forgeVersion)
        {
            Version version;
            if (!Version.TryParse(forgeVersion, out version))
            {
                throw new ArgumentException("Invalid forge version string", "forgeVersion");
            }

            VersionName = version.ToString();
            VersionSlug = VersionName.Replace('.', '-');
            ModLoaderName = string.Format("forge-{0}", VersionName);
        }

        public string ModLoaderName { get; private set; }

        public string VersionName { get; private set; }

        public string VersionSlug { get; private set; }
    }
}
