﻿using System.Collections.Generic;

namespace Curse.Minecraft.Jobs.Forge
{
    // ReSharper disable InconsistentNaming

    /// <summary>
    ///     Model class for deserialization of installer_profile.json in Forge installer builds.
    /// </summary>
    internal class ForgeInstallProfile
    {
        public ForgeInstallProfileInstall install { get; set; }
        public ForgeInstallProfileVersionInfo versionInfo { get; set; }
    }

    public class ForgeInstallProfileInstall
    {
        public string profileName { get; set; }
        public string target { get; set; }
        public string path { get; set; }
        public string version { get; set; }
        public string filePath { get; set; }
        public string welcome { get; set; }
        public string minecraft { get; set; }
        public string mirrorList { get; set; }
        public string logo { get; set; }
    }

    public class ForgeInstallProfileOs
    {
        public string name { get; set; }
    }

    public class ForgeInstallProfileRule
    {
        public string action { get; set; }
        public ForgeInstallProfileOs os { get; set; }
    }

    public class ForgeInstallProfileNatives
    {
        public string linux { get; set; }
        public string windows { get; set; }
        public string osx { get; set; }
    }

    public class ForgeInstallProfileExtract
    {
        public List<string> exclude { get; set; }
    }

    public class ForgeInstallProfileLibrary
    {
        public string name { get; set; }
        public string url { get; set; }
        public bool? serverreq { get; set; }
        public List<string> checksums { get; set; }
        public string comment { get; set; }
        public bool? clientreq { get; set; }
        public List<ForgeInstallProfileRule> rules { get; set; }
        public ForgeInstallProfileNatives natives { get; set; }
        public ForgeInstallProfileExtract extract { get; set; }
    }

    public class ForgeInstallProfileVersionInfo
    {
        public string id { get; set; }
        public string time { get; set; }
        public string releaseTime { get; set; }
        public string type { get; set; }
        public string minecraftArguments { get; set; }
        public List<ForgeInstallProfileLibrary> libraries { get; set; }
        public string mainClass { get; set; }
        public int minimumLauncherVersion { get; set; }
    }

    // ReSharper enable InconsistentNaming
}