﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Newtonsoft.Json;

namespace Curse.Minecraft.Jobs.Forge
{
    class GradleForgeListJson
    {
        [JsonProperty("number")]
        public IDictionary<string,GradleForgeBuildJson> Builds { get; set; }

        [JsonProperty("promos")]
        public IDictionary<string, string> Promos { get; set; }

        [JsonProperty("webpath")]
        public Uri WebPath { get; set; }
    }

    class GradleForgeBuildJson
    {
        [JsonProperty("version")]
        public string ForgeVersion { get; set; }
        [JsonProperty("mcversion")]
        public string MinecraftVersion { get; set; }
        [JsonProperty("branch")]
        public string Branch { get; set; }
        [JsonProperty("modified")]
        public long ModifiedEpoch { get; set; }
        [JsonProperty("files")]
        public List<GradleForgeFileJson> Files { get; set; } 
    }

    class GradleForgeFileJson : List<string>
    {
        public string FileType
        {
            get { return Count > 0 ? this[0] : null; }
        }

        public string BuildType { get { return Count > 1 ? this[1] : null; } }
    }
}
