﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using Curse.Logging;
using Curse.Minecraft.Jobs.Utilities;

namespace Curse.Minecraft.Jobs.Forge
{
    /// <summary>
    ///     Model class for managing maven strings for Minecraft instance dependencies
    /// </summary>
    [Obfuscation(ApplyToMembers = true)]
    public class MavenPackageString
    {        
        public MavenPackageString(string packageName, Uri url = null, string extension = "jar")
        {
            var keys = packageName.Split(':');
            Package = keys[0];
            Name = keys[1];
            Version = keys[2];

            RelativeUrl = new Uri(string.Format("{0}/{1}/{2}/{3}", Package.Replace('.', '/'), Name, Version, string.Format("{0}-{1}.{2}", Name, Version, extension)), UriKind.Relative);

            if (extension != null)
            {
                FileName = GetFileName(extension);
            }
            if (url != null)
            {
                PrimaryBaseUrl = url;
                var urls = new List<Uri>();
                urls.Add(PrimaryBaseUrl);
                urls.AddRange(Constants.LibraryMirrors);
                AllBaseUrls = urls.ToArray();
            }
        }

        
        public string Package { get; set; }
        public string Name { get; set; }
        public string Version { get; set; }

        public string FileName { get; set; }
        public Uri RelativeUrl { get; set; }        
        public Uri PrimaryBaseUrl { get; set; }
        public Uri[] AllBaseUrls { get; set; }

        public string LibPath
        {
            get { return Path.Combine("{0}", Constants.LibraryDirectoryName, Package.Replace('.', '\\'), Name, Version); }
        }

        public string FullPath
        {
            get { return Path.Combine(LibPath, GetFileName("jar")); }
        }

        public override string ToString()
        {
            return string.Format("{0}:{1}:{2}", Package, Name, Version);
        }

        public string GetFileName(string extension)
        {
            return string.Format("{0}-{1}.{2}", Name, Version, extension);
        }

        public Uri GetAbsoluteUrl(Uri baseUrl)
        {
            return new Uri(baseUrl, RelativeUrl);
        }
    }
}