﻿using System;
using Curse.Database.Helpers;

namespace Curse.Minecraft.Jobs.Minecraft
{
    public class MinecraftGameVersionInfo
    {
        public MinecraftGameVersionInfo(string mcVersion)
        {
            Version version;
            if (!Version.TryParse(mcVersion, out version))
            {
                throw new ArgumentException("Version String had a bad format", "mcVersion");
            }

            VersionName = version.ToString();
            VersionSlug = VersionName.Replace('.', '-');

            TypeSlug = String.Format("minecraft-{0}-{1}", version.Major, version.Minor);
            TypeName = String.Format("{0}.{1}", version.Major, version.Minor);
        }

        public string VersionSlug { get; private set; }

        public string VersionName { get; private set; }

        public string TypeSlug { get; private set; }

        public string TypeName { get; private set; }
    }
}