﻿using System;
using System.Reflection;

namespace Curse.Minecraft.Jobs.Utilities
{
    internal static class Constants
    {
        // Mojang
        public const string MinecraftVersionListUrl = "https://s3.amazonaws.com/Minecraft.Download/versions/versions.json";

        public const string MinecraftVersionJarMask = "https://s3.amazonaws.com/Minecraft.Download/versions/{0}/{0}.jar";

        public const string MinecraftVersionJsonMask = "https://s3.amazonaws.com/Minecraft.Download/versions/{0}/{0}.json";

        // Forge
        public const string ForgeGradleVersionListUrl = "http://files.minecraftforge.net/maven/net/minecraftforge/forge/json";

        public const string ForgeLegacyVersionListUrl = "http://files.minecraftforge.net/minecraftforge/json";                

        // Processing                
        public const string LibraryDirectoryName = "libraries";

        public static readonly Uri[] LibraryMirrors =
        {
            new Uri("https://minecraftforge.cursecdn.com/maven/"),
            new Uri("https://mavencentral.cursecdn.com/maven2/"),
            new Uri( "https://repo1.maven.org/maven2/"),
            new Uri("http://files.mincraftforge.com/maven/")
        };

        // Database
        public const string ForgeGameVersionTypeSlug = "forge";
        public const string ForgeValidationGroup = "forge";
        public const string MinecraftValidationGroup = "minecraft";

        // Web
        public const int DownloadTimeoutPeriod = 30000; // Download timeout in milliseconds

        internal static readonly string HttpUserAgent = GetHttpUserAgent();
        private static string GetHttpUserAgent()
        {
            var version = Assembly.GetExecutingAssembly().GetName().Version;
            return string.Format("Curse/{0}.{1} ({2}) Curse/{3}.{4}.{5}.{6}",
                version.Major,
                version.Minor,
                Environment.OSVersion.VersionString,
                version.Major,
                version.Minor,
                version.Build,
                version.Revision
                );
        }

    }
}