﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Jobs.Runner.Configuration;

namespace Curse.Minecraft.Jobs.Utilities
{
    public class ModLoaderUrl
    {

        public ModLoaderUrl(string partialPath, string fullPath)
        {
            PartialUrl = new Uri(new Uri(MinecraftJobConfiguration.Instance.ModLoaderBaseUrl), partialPath);
            FullUrl = new Uri(new Uri(MinecraftJobConfiguration.Instance.ModLoaderBaseUrl), fullPath);
        }

        public ModLoaderUrl(string fullPath)
        {            
            FullUrl = new Uri(new Uri(MinecraftJobConfiguration.Instance.ModLoaderBaseUrl), fullPath);
        }

        public Uri PartialUrl { get; set; }

        public Uri FullUrl { get; set; }
    }
}
