﻿using System;
using System.Net;

namespace Curse.Minecraft.Jobs
{
    internal class WebClientWithTimeout : WebClient
    {
        private int _timeout = 1000 * 10; // 10 Seconds;
        private string _userAgent = null;

        public int Timeout
        {
            get
            {
                return _timeout;
            }
            set
            {
                _timeout = value;
            }
        }



        public string UserAgent
        {
            get
            {
                return _userAgent;
            }
            set
            {
                _userAgent = value;
            }
        }

        public WebClientWithTimeout(int timeoutMilliseconds)
        {
            Timeout = timeoutMilliseconds;
        }
        public WebClientWithTimeout(int timeoutMilliseconds, string useragent)
        {
            Timeout = timeoutMilliseconds;
            UserAgent = useragent;
        }

        protected override WebRequest GetWebRequest(Uri address)
        {
            var request = base.GetWebRequest(address);
            request.Timeout = Timeout;
            if (UserAgent != null)
            {
                (request as HttpWebRequest).UserAgent = UserAgent;
            }
            return request;
        }

    }
}