﻿using System.Collections.Generic;
using System.Data.SqlClient;
using Curse.AddOns;
using Curse.Database.Helpers;

namespace Curse.Minecraft.Models
{
    public static class GameVersionExtensions
    {

        public static GameVersion SetFromDataReader(this GameVersion value, SqlDataReader reader)
        {
            value.ID = reader.Get<int>("ID");
            value.GameVersionTypeID = reader.Get<int>("GameVersionTypeID");
            value.Status = reader.Get<byte>("Status");
            value.Name = reader.Get<string>("Name");
            value.Slug = reader.Get<string>("Slug");
            return value;
        }

        public static void SaveToDatabase(this GameVersion value, SqlConnection connection, SqlTransaction transaction)
        {
            if (value.ID != 0)
            {
                // Only inserts are allowed
                return;
            }
            using (var command = connection.CreateCommand())
            {
                command.Transaction = transaction;

                command.CommandText = "INSERT INTO [GameVersion] (GameID,GameVersionTypeID,Status,Name,Slug) OUTPUT INSERTED.ID VALUES (@GameID,@GameVersionTypeID,@Status,@Name,@Slug)";
                command.Parameters.AddWithValue("@GameID", 432); // 432=Minecraft
                command.Parameters.AddWithValue("@GameVersionTypeID", value.GameVersionTypeID);
                command.Parameters.AddWithValue("@Status", (byte)3); // 3=Unapproved
                command.Parameters.AddWithValue("@Name", value.Name);
                command.Parameters.AddWithValue("@Slug", value.Slug);

                value.ID = (int)command.ExecuteScalar();
            }
        }

        public static GameVersion Get(int id)
        {
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.Elerium))
            {
                using (var command = conn.CreateCommand())
                {
                    command.Parameters.AddWithValue("@ID", id);
                    command.CommandText = "SELECT * FROM [GameVersion] WHERE ID=@ID";

                    using (var reader = command.ExecuteReader())
                    {
                        if (!reader.Read())
                        {
                            return null;
                        }

                        var model = new GameVersion();
                        model.SetFromDataReader(reader);
                        return model;
                    }
                }
            }
        }

        public static GameVersion[] GetAllBySlugAndType(SqlConnection conn, SqlTransaction transaction, string slug, GameVersionType type)
        {
            var versions = new List<GameVersion>();
            using (var command = conn.CreateCommand())
            {
                command.Transaction = transaction;
                command.Parameters.AddWithValue("@Slug", slug);
                command.Parameters.AddWithValue("@GameVersionTypeID", type.ID);
                command.CommandText = "SELECT * FROM [GameVersion] WHERE GameID=432 AND Slug=@Slug AND GameVersionTypeID=@GameVersionTypeID";

                using (var reader = command.ExecuteReader())
                {
                    while (reader.Read())
                    {

                        versions.Add(new GameVersion().SetFromDataReader(reader));
                    }
                }
            }
            return versions.ToArray();
        }
    }
}