﻿using System.Data.SqlClient;
using Curse.Database.Helpers;
using Curse.AddOns;

namespace Curse.Minecraft.Models
{
    public static class GameVersionMappingExtensions
    {

        public static void SaveToDatabase(this GameVersionMapping value, SqlConnection connection, SqlTransaction transaction)
        {
            if (value.ID != 0)
            {
                // Only Inserts are allowed, no updates
                return;
            }

            using (var command = connection.CreateCommand())
            {
                command.Transaction = transaction;
                command.CommandText = string.Format("INSERT INTO [GameVersionMapping] ({0},{1}) OUTPUT INSERTED.ID VALUES (@{0},@{1})",
                    "GameVersionID", "RelatedGameVersionID");
                command.Parameters.AddWithValue("@GameVersionID", value.GameVersionID);
                command.Parameters.AddWithValue("@RelatedGameVersionID", value.RelatedGameVersionID);
                value.ID = (int)command.ExecuteScalar();
            }
        }

        private static void SetFromDataReader(this GameVersionMapping value, SqlDataReader reader)
        {
            value.ID = reader.Get<int>("ID");
            value.GameVersionID = reader.Get<int>("GameVersionID");
            value.RelatedGameVersionID = reader.Get<int>("RelatedGameVersionID");
        }

        public static GameVersionMapping Get(int gameVersionID, int relatedGameVersionID)
        {
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.Elerium))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [GameVersionMapping] WHERE GameVersionID=@GameVersionID AND RelatedGameVersionID=@RelatedGameVersionID";
                    command.Parameters.AddWithValue("@GameVersionID", gameVersionID);
                    command.Parameters.AddWithValue("@RelatedGameVersionID", relatedGameVersionID);
                    using (var reader = command.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            var model = new GameVersionMapping();
                            model.SetFromDataReader(reader);
                            return model;
                        }
                        return null;
                        
                    }
                }
            }
        }
    }
}
