﻿using System.Collections.Generic;
using System.Data.SqlClient;
using Curse.AddOns;
using Curse.Database.Helpers;

namespace Curse.Minecraft.Models
{
    public static class GameVersionTypeExtensions
    {
     
        public static void SetFromDataReader(this GameVersionType gameVersion, SqlDataReader reader)
        {
            gameVersion.ID = reader.Get<int>("ID");
            gameVersion.Status = reader.Get<byte>("Status");
            gameVersion.Slug = reader.Get<string>("Slug");
            gameVersion.Name = reader.Get<string>("Name");
            gameVersion.ValidationGroupName = reader.Get<string>("ValidationGroupName");
        }
        
        public static void SaveToDatabase(this GameVersionType gameVersion)
        {
            using (var connection = DatabaseConnectionHelper.GetConnection(DatabaseType.Elerium))
            {
                using (var transaction = connection.BeginTransaction())
                {
                    try
                    {
                        SaveToDatabase(gameVersion, connection, transaction);
                        transaction.Commit();
                    }
                    catch
                    {
                        transaction.Rollback();
                        throw;
                    }
                }
            }
        }

        public static void SaveToDatabase(this GameVersionType gameVersion, SqlConnection connection, SqlTransaction transaction)
        {
            using (var command = connection.CreateCommand())
            {
                if (gameVersion.ID != 0)
                {
                    // Only inserts are allowed for this type - no modifications
                    return;
                }

                command.Transaction = transaction;

                command.CommandText = string.Format("INSERT INTO [GameVersionType] ({0},{1},{2},{3},{4}) OUTPUT INSERTED.ID VALUES (@{0},@{1},@{2},@{3},@{4})",
                    "Status","Slug", "Name", "GameID", "ValidationGroupName");
                command.Parameters.AddWithValue("@Status", (byte) 1);
                command.Parameters.AddWithValue("@Slug", gameVersion.Slug);
                command.Parameters.AddWithValue("@Name", gameVersion.Name);
                command.Parameters.AddWithValue("@GameID", 432);
                command.Parameters.AddWithValue("@ValidationGroupName", gameVersion.ValidationGroupName);
                gameVersion.ID = (int)command.ExecuteScalar();
            }
        }

        public static GameVersionType[] GetAllBySlug(SqlConnection conn, SqlTransaction transaction, string slug)
        {
            var types = new List<GameVersionType>();
            using (var command = conn.CreateCommand())
            {
                command.Transaction = transaction;
                command.CommandText = "SELECT * FROM [GameVersionType] WHERE Slug=@Slug AND GameID=@GameID AND Status=@Status";
                command.Parameters.AddWithValue("@Slug", slug);
                command.Parameters.AddWithValue("@GameID", 432);
                command.Parameters.AddWithValue("@Status", (byte) 1);

                using (var reader = command.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        var model = new GameVersionType();
                        model.SetFromDataReader(reader);
                        types.Add(model);
                    }
                }
            }
            return types.ToArray();
        }

        public static GameVersionType[] GetAllBySlug(string slug)
        {
            using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.Elerium))
            {
                using (var transaction = conn.BeginTransaction())
                {
                    return GetAllBySlug(conn, transaction, slug);
                }
            }
        }
    }
}