﻿using System.Collections.Generic;
using System.Data.SqlClient;
using Curse.Database.Helpers;

namespace Curse.Minecraft.Models
{	
	public static class MinecraftGameVersionExtensions
	{
		
		public static void SetFromDataReader(this MinecraftGameVersion model, SqlDataReader reader)
		{
            model.ID = reader.Get<int>("ID");
            model.GameVersionID = reader.Get<int>("GameVersionID");
            model.JarDownloadUrl = reader.Get<string>("JarDOwnloadUrl");
            model.JsonDownloadUrl = reader.Get<string>("JsonDownloadUrl");
            model.Approved = reader.Get<bool>("ApprovedForClient");
            model.VersionString = reader.Get<string>("VersionString");
		}

        public static void SaveToDatabases(this MinecraftGameVersion model, SqlConnection connection, SqlTransaction transaction)
		{
            if (model.ID != 0)
			{
				// Only inserts are allowed
				return;
			}

			using (var command = connection.CreateCommand())
			{
				command.Transaction = transaction;

				command.CommandText = string.Format("INSERT INTO [MinecraftGameVersion] ({0},{1},{2},{3}) OUTPUT INSERTED.ID VALUES (@{0},@{1},@{2},@{3})",
					"GameVersionID", "JarDownloadUrl", "JsonDownloadUrl", "ApprovedForClient");
                command.Parameters.AddWithValue("@JarDownloadUrl", model.JarDownloadUrl);
                command.Parameters.AddWithValue("@JsonDownloadUrl", model.JsonDownloadUrl);
				command.Parameters.AddWithValue("@ApprovedForClient", false);
                command.Parameters.AddWithValue("@GameVersionID", model.GameVersionID);

                model.ID = (int)command.ExecuteScalar();
			}
		}

		private const string QueryString = @"SELECT mc.*,gv.Name as VersionString
											FROM [MinecraftGameVersion] as mc
											JOIN [GameVersion] as gv
											ON mc.GameVersionID=gv.ID";

		public static MinecraftGameVersion[] GetAll()
		{
			var versions = new List<MinecraftGameVersion>();
			using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.Elerium))
			{
				using (var command = conn.CreateCommand())
				{
					command.CommandText = QueryString;
					using (var reader = command.ExecuteReader())
					{
						while (reader.Read())
						{
                            var model = new MinecraftGameVersion();
                            model.SetFromDataReader(reader);
                            versions.Add(model);
						}
					}
				}
			}

			return versions.ToArray();
		}



		public static MinecraftGameVersion GetByGameVersion(SqlConnection conn, SqlTransaction transaction, int gameVersionID)
		{
			using (var command = conn.CreateCommand())
			{
				command.Transaction = transaction;
				command.Parameters.AddWithValue("@GameVersionID", gameVersionID);
				command.CommandText = string.Format("{0} {1}", QueryString, "WHERE mc.GameVersionID=@GameVersionID");

				using (var reader = command.ExecuteReader())
				{
				    if (!reader.Read())
				    {
				        return null;
				    }

                    var model = new MinecraftGameVersion();
                    model.SetFromDataReader(reader);
				    return model;
				}
			}
		}

		public static MinecraftGameVersion GetByGameVersion(int gameVersionID)
		{
			using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.Elerium))
			{
				using (var transaction = conn.BeginTransaction())
				{
					return GetByGameVersion(conn, transaction, gameVersionID);
				}
			}
		}

		public static MinecraftGameVersion[] GetAllNewAndNormal()
		{
			var versions = new List<MinecraftGameVersion>();
			using (var conn = DatabaseConnectionHelper.GetConnection(DatabaseType.Elerium))
			{
				using (var command = conn.CreateCommand())
				{
					command.CommandText =
						@"SELECT mc.*,gv.Name as VersionString
						FROM [MinecraftGameVersion] as mc
						JOIN [GameVersion] as gv
							JOIN [GameVersionType] as gvt
							ON gv.GameVersionTypeID=gvt.ID
						ON mc.GameVersionID=gv.ID
						WHERE (gv.[Status]=1 OR gv.[Status]=3) AND (gvt.[Status]=1)";
					using (var reader = command.ExecuteReader())
					{
                        while (reader.Read())
                        {
                            var model = new MinecraftGameVersion();
                            model.SetFromDataReader(reader);
                            versions.Add(model);
                        }						
					}
				}
			}
			return versions.ToArray();
		}

	}
}