﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.Serialization;
using Curse.AddOns;

namespace Curse.Minecraft.Models
{

    public class MinecraftGameVersionComparer : IComparer<string>
    {
       
        public int Compare(string x, string y)
        {
            var vx = new Version(x);
            var vy = new Version(y);
            return vx.CompareTo(vy);
        }
    }


	[DataContract]
	public class MinecraftGameVersion
	{        
		public int ID { get; set; }

		public int GameVersionID { get; set; }

		[DataMember]
		public string JarDownloadUrl { get; set; }

		[DataMember]
		public string JsonDownloadUrl { get; set; }

		[DataMember]
		public bool Approved { get; set; }
		
		[DataMember]
		public string VersionString { get; set; }

		public MinecraftGameVersion(GameVersion version)
		{
			GameVersionID = version.ID;
			VersionString = version.Name;
		}

	    public MinecraftGameVersion()
	    {
	    }
	}
}