﻿using System;
using Curse.AddOns;

namespace Curse.Minecraft.Models
{
    public class MinecraftGameVersionFeed : FeedFile<MinecraftGameVersion>
    {        
        public new const int Version = 10;
        private const int _gameID = 432;
        
        public override string RelativeFolderPath
        {
            get { return "gameversions/" + _gameID + "/v" + Version; }
        }

        public override string RelativeUrlPath
        {
            get
            {
                return "feed/" + RelativeFolderPath;                
            }
        }

        public override string FileName
        {
            get
            {
                return "gameversions.json.bz2";
            }
        }        
    }
}
